import { BuildPlugin } from '../@types';

export const load: BuildPlugin.load = function () {
    console.debug(`${PACKAGE_NAME} load`);
};

export const unload: BuildPlugin.load = function () {
    console.debug(`${PACKAGE_NAME} unload`);
};

const PACKAGE_NAME = 'duiba-publish';

export const configs: BuildPlugin.Configs = {
    'web-mobile': {
        hooks: './hooks',
        doc: 'editor/publish/custom-build-plugin.html',
        options: {
            useZip: {
                label: '使用zip压缩Bundle',
                default: true,
                render: {
                    ui: 'ui-checkbox',
                }
            },
            useJsEncryption: {
                label: '使用JS加密（线上必须启用）',
                default: true,
                render: {
                    ui: 'ui-checkbox',
                }
            },
            uploadDir: {
                label: '上传文件夹',
                description: '要上传到哪个子文件夹',
                default: 'db_games/ccc_game/template3d',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'db_games/ccc_game/template3d',
                    },
                },
                verifyRules: ['required']
            },
            cdnDomain: {
                label: 'cdn域名',
                description: 'cdnDomain',
                default: '//yun.duiba.com.cn',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: '//yun.duiba.com.cn',
                    },
                },
                verifyRules: ['required']
            },
            // endPoint: {
            //     label: 'endPoint',
            //     description: 'endPoint',
            //     default: '',
            //     render: {
            //         ui: 'ui-input',
            //         attributes: {
            //             placeholder: 'region',
            //         },
            //     },
            //     // verifyRules: ['required']
            // },
            region: {
                label: 'region',
                description: 'region',
                default: 'oss-cn-hangzhou',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'region',
                    },
                },
                verifyRules: ['required']
            },
            bucket: {
                label: 'bucket',
                description: 'bucket',
                default: 'duiba',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'bucket',
                    },
                },
                verifyRules: ['required']
            },
            accessKeyId: {
                label: 'accessKeyId',
                description: 'accessKeyId',
                default: 'LTAI5tPUSSxgkEmKPAfVXUQQ',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        // password: true,
                        placeholder: 'accessKeyId',
                    },
                },
                verifyRules: ['required']
            },
            accessKeySecret: {
                label: 'accessKeySecret',
                description: 'accessKeySecret',
                default: '6sk3EDd1BYrXlAUoh8maMuN7hOMkh1',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        // password: true,
                        placeholder: 'accessKeySecret',
                    },
                },
                verifyRules: ['required']
            },
        },
    },
};
