import { _decorator, easing, Node, tween, v3 } from "cc";
import Module from "./Module";
import { hidePanel } from "./UIFast";
import { loadAllObject } from "db://assets/Scripts/Utils/Utils";
import { UIMgr } from "./UIMgr";

const {ccclass, property} = _decorator;

@ccclass()
export default class Panel extends Module {
    view: { [key in string]: Node } = {};

    onLoad() {
        this.view = loadAllObject(this.node);
    }

    onShow() {
        if (this.data.panelType == "scrollTop") {
            this.node.setPosition(v3(0, -812, 0));
            tween(this.node)
                .to(0.188, { position: v3(0, 0, 0)}, { easing: easing.quadInOut })
                .start();

        } else if (this.data.panelType == "topNoScale") {
            // 居顶适配 且不需要缩放动效
            this.node.setPosition(v3(0, 0, 0));
        } else {
            this.node.setScale(v3(0, 0, 1));
            tween(this.node)
                .to(0.188, { scale: v3(1, 1, 1) }, { easing: easing.quadInOut })
                .start();
        }
    }

    hidePanel() {
        this.node.emit('close-panel');
        // PanelCtrl.ins.hide();
        const parent = this.node.parent;
        hidePanel();
        // parent.getComponent(PanelCtrl)?.hide();
        // parent.getComponent(TopCtrl)?.hide();
    }

    hideAllPanel() {
        this.node.emit('close-panel');
        UIMgr.ins.hideAllPanel();
    }

}
