// export enum ESpType {
//   bag_silver = "sp_bag_silver",           // 银福袋
//   revival_card = "sp_revival_card",       // 复活卡
//   shield_card = "sp_shield_card",         // 护盾卡
//   agility_card = "sp_agility_card",       // 移速卡
//   experience_card = "sp_experience_card", // 双倍卡
//   add_length = "sp_add_length",           // 加长卡
//   decoration_1 = "sp_decoration_1",       // 蛇皮肤
// }

import * as fs from "fs";
import CryptoJS from "crypto-js";
import "crypto-js/aes.js";
import "crypto-js/pad-zeropadding.js";

const { AES, enc, mode, pad } = CryptoJS;

const getOptions = (iv) => {
  return {
    iv: enc.Utf8.parse(iv),
    mode: mode.CBC,
    padding: pad.ZeroPadding,
  };
};

/** 加密 */
const AESEncrypt = (str, key, iv) => {
  const options = getOptions(iv);

  return AES.encrypt(str, enc.Utf8.parse(key), options).toString();
};

const startInfo = {
  "success": true,
  "code": "aliqua",
  "message": "elit labore officia",
  "data": {
    "dividePop": {
      "boolShowPop": true,
      "creditsNum": 63531192.6826255,
      "rankOrder": 22623198.524720147,
      "rankMultiply": -19156595.052414536
    },
    "settlementPop": {
      "boolShowPop": false,
      "oldRankMultiply": 3665430.901954502,
      "newRankMultiply": 54872899.88186678,
      "rankList": [
        {
          "nickName": "commodo et",
          "rankScore": -82832898.38315952,
          "boolMe": false
        },
        {
          "nickName": "enim",
          "rankScore": -21623649.454001635,
          "boolMe": true
        },
        {
          "nickName": "dolore labore officia",
          "rankScore": 62514159.900907576,
          "boolMe": true
        },
        {
          "nickName": "nisi pariatur enim",
          "rankScore": 24135109.546333224,
          "boolMe": false
        }
      ],
      "obtainScoreNum": 41928744.96082327
    },
    "normalNum": 94418248.61070254,
    "actEndTime": 61476505.152483135,
    "actStartTime": -77576061.07275513,
    "remainCredits": 2973421.0857937634,
    "currentEnergy": {
      "initEnergy": -77441816.43353301,
      "eachEnergyTime": -13037487.194406435,
      "energyLimit": 15516683.487120673,
      "fullEnergyTime": 49595243.10261455,
      "exchangeEnergyConfigs": [
        {
          "creditNum": -26416378.031490013,
          "awardNum": -47871162.17248078,
          "id": "et amet labore Ut nisi"
        },
        {
          "creditNum": -25421744.71314569,
          "awardNum": -23074453.37296419,
          "id": "nulla dolor aliquip"
        }
      ]
    },
    "eachLuckCredits": 95639771.03440803,
    "poolConfig": {
      "normalNum": 3314007.783894852,
      "goldNum": 41241520.736848354
    },
    "goldNum": 21741573.059883863,
    "taskCompletePops": [
      {
        "taskCode": "esse in aliqua est",
        "awardNum": "incididunt minim esse et",
        "awardSpId": "tempor",
        "times": -61547165.130221695
      }
    ],
    "currentMultiple": {
      "doubleStartTime": 56387747.478479564,
      "doubleEndTime": -55127322.290328704,
      "awardNormalNum": -31825860.77529104,
      "rate": "laboris sit proident ullamco labore",
      "awardGoldNum": 57015800.51045534
    },
    "userId": "aute consequat eiusmod do in",
    "greenNum": -53869221.438158065,
    "greenExchangeConfig": {
      "consumeNum": "veniam culpa sit laboris do",
      "awardNum": 55313226.647502124,
      "awardSpId": "deserunt ad"
    },
    "boolJoinRank": true,
    "currentPoolNormalNum": 7008200.743696675,
    "currentPoolGoldNum": -59205334.61904922
  }
};

const encrypt = AESEncrypt(JSON.stringify(startInfo), "6FDCE02EBB43C3A8", "cDOiBC1n2QrkAY2P");

const json = {
  success: true,
  code: "",
  message: "",
  data: encrypt
};

fs.writeFileSync("./index.do.json", JSON.stringify(json, null, 4));