import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";
import { observer, render } from "db://assets/Scripts/store/decorators";
import store from "db://assets/Scripts/store/store";

const { ccclass, property } = _decorator;

@observer
@ccclass('PrizePanel')
export class PrizePanel extends Panel {
    static skin: string = "PrizePanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) okBtn2: Node = null;
    @property(Node) closeBtn: Node = null;

    @property(Sprite) img: Sprite = null;
    @property(Label) prizeName: Label = null;

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.closeBtn.on(Button.EventType.CLICK, this.cancel, this);
    }

    @render
    render() {
        const { boxConfigs } = store.homeInfo;
        const noOpen = boxConfigs?.filter((item) => {
            return +item.status != 1
        });

        if (noOpen?.length) {
            this.okBtn2.active = true;
            this.okBtn.active = false;
            this.okBtn2.getComponentInChildren(Label).string = `继续开宝箱*${noOpen.length}`;
        } else {
            this.okBtn2.active = false;
            this.okBtn.active = true;
        }

    }

    start(): void {
        const { optionImg, optionName } = this.data;
        this.img.spriteFrame = optionImg;
        this.prizeName.string = optionName;
    }

    cancel = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

    ok = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

}


