"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zipDir = void 0;
const fs = __importStar(require("fs"));
const jszip_1 = __importDefault(require("jszip"));
//��ȡĿ¼���ļ�
function readDir(zip, nowPath) {
    const files = fs.readdirSync(nowPath);
    files.forEach(function (fileName, index) {
        console.log(fileName, index); //��ӡ��ǰ��ȡ���ļ���
        const fillPath = nowPath + "/" + fileName;
        const file = fs.statSync(fillPath); //��ȡһ���ļ�������
        if (file.isDirectory()) { //�����Ŀ¼�Ļ���������ѯ
            const dirlist = zip.folder(fileName); //ѹ�����������ɸ�Ŀ¼
            readDir(dirlist, fillPath); //���¼���Ŀ¼�ļ�
        }
        else {
            // �ų�ͼƬ�ļ�
            if (fileName.endsWith(".png") || fileName.endsWith(".jpg")) {
                return;
            }
            zip.file(fileName, fs.readFileSync(fillPath)); //ѹ��Ŀ¼�����ļ�
        }
    });
}
//��ʼѹ���ļ�
function zipDir(name, dir, dist) {
    return new Promise((resolve, reject) => {
        const zip = new jszip_1.default();
        readDir(zip, dir);
        zip.generateAsync({
            type: "nodebuffer", //nodejs��
            compression: "DEFLATE", //ѹ���㷨
            compressionOptions: {
                level: 9
            }
        }).then(function (content) {
            fs.writeFileSync(`${dist}/${name}.bin`, content, "utf-8");
            resolve();
        });
    });
}
exports.zipDir = zipDir;
