import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";
import { changeScene } from "db://assets/core/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";

const { ccclass, property } = _decorator;

@ccclass('SucPanel')
export class SucPanel extends Panel {
    static skin: string = "SucPanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) closeBtn: Node = null;
    @property(Label) levelNum: Label = null;
    @property(Label) boxNum: Label = null;

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.closeBtn.on(Button.EventType.CLICK, this.close, this);
    }

    start(): void {
        this.levelNum.string = `第${this.data.passLevel}关`;
        this.boxNum.string = `挑战宝箱*${this.data.boxNum}`;
    }

    close = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
        changeScene(HomeScene);
    }

    ok = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
        changeScene(HomeScene);
    }

}


