import { _decorator, Component, find, Node } from 'cc';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { UIBase } from '../Components/UIBase';
import { PlatformManager } from '../../../ScriptFrame/Frame/platformManager';
import { GamePage } from './GamePage';
import { AudioManager, AudioClipNames } from '../../../ScriptFrame/Frame/AudioManager';
import { showToast } from "db://assets/Module/UIFast";
const { ccclass, property } = _decorator;

@ccclass('VipPage')
export class VipPage extends UIBase {
    useClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        PlatformManager.instance.showVideoAd(()=>{
            const gamePage = CarColorsGlobalInstance.instance.uiSysterm.UIScrpits.get(UINames[UINames.GamePage]) as GamePage
            gamePage.isChooseHelicopterTarget = true
            gamePage.node.getChildByName("chooseTip").active = true
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.VipPage)
            AudioManager.instance.playOneShot(AudioClipNames.upgrade)
        },()=>{
            showToast("视频播放未完成！")
        })
    }
    closeClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.VipPage)
        CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
    }
}
