import { _decorator, Component, Node } from 'cc';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { UIBase } from '../Components/UIBase';
import { PlatformManager } from '../../../ScriptFrame/Frame/platformManager';
import { AudioManager, AudioClipNames } from '../../../ScriptFrame/Frame/AudioManager';
import { showToast } from "db://assets/Module/UIFast";
const { ccclass, property } = _decorator;

@ccclass('RefreshPage')
export class RefreshPage extends UIBase {
    useClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        PlatformManager.instance.showVideoAd(()=>{
            CarColorsGlobalInstance.instance.carSysterm.refreshCar()
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RefreshPage)
            CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
            AudioManager.instance.playOneShot(AudioClipNames.upgrade)
        },()=>{
            showToast("视频播放未完成！")
        })
    }
    closeClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RefreshPage)
        CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
    }
}


