import { _decorator, Component, find, instantiate, Label, Node, ProgressBar } from 'cc';
import { UIBase } from '../Components/UIBase';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { GlobalData, ConfigKeys } from '../../../ScriptFrame/GlobalData';
import { AudioClipNames, AudioManager } from '../../../ScriptFrame/Frame/AudioManager';
import { showToast } from "db://assets/Module/UIFast";
const { ccclass, property } = _decorator;

@ccclass('HomePage')
export class HomePage extends UIBase {
    @property(Node)
    startBtn: Node = null
    show(opts?: any): void {
        super.show(opts)
        this.startBtn.active = true
        AudioManager.instance.playBgm(AudioClipNames.bgm)
        CarColorsGlobalInstance.instance.roleSysterm.showHomeRoles()
        find("Scene/map").destroyAllChildren()
        find("Scene/map").removeAllChildren()
        find("Scene/Levels").destroyAllChildren()
        find("Scene/Levels").removeAllChildren()
        find("Scene/Parkings").active = false
        find("Scene/homeScene").active = true
        find("Main Camera").active = false
        find("HomeCamera").active = true
    }
    async startGame(){
        this.startBtn.active = false
        find("Main Camera").active = true
        find("HomeCamera").active = false
        find("UI/BundleLoading").active = true
        find("UI/BundleLoading/ProgressBar").getComponent(ProgressBar).progress = 0.5
        find("UI/BundleLoading/Text").getComponent(Label).string = "场景加载中"
        find("Scene/homeScene").active = false

        find("Scene/Parkings").children.forEach((child, index)=>{
            if (index < 4){
                child.name = "empty"
            }else{
                child.name = "lock"
                child.children[0].children[0].active = false
                child.children[0].children[1].active = true
            }
            child.children[1]?.destroy()
            child.children[1]?.removeFromParent()
        })
        find("Scene/Parkings").active = true
        CarColorsGlobalInstance.instance.roleSysterm.clearAll()
        CarColorsGlobalInstance.instance.carSysterm.clearAll()
        const map = await CarColorsGlobalInstance.instance.bundleSysterm.loadMap(GlobalData.instance.map)
        find("Scene/map").addChild(instantiate(map))
        CarColorsGlobalInstance.instance.bundleSysterm.loadLevels(GlobalData.instance.getConfigData(ConfigKeys.GameSaveData).level).then((level)=>{
            console.log("instantiate(level)")
            const Level = instantiate(level)
            find("Scene/Levels").addChild(Level)
            for(let i = 0; i < Level.children.length;i++){
                CarColorsGlobalInstance.instance.carSysterm.addCar(Level.children[i])
            }
            CarColorsGlobalInstance.instance.roleSysterm.initLevel()
            CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.GamePage)
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.HomePage)
            find("UI/BundleLoading").active = false
        }).catch((err)=>{
            console.log(err)
            showToast("关卡正在制作中")
            this.startBtn.active = true
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.GamePage)
        })

        AudioManager.instance.playOneShot(AudioClipNames.start)
    }
}

