import { _decorator, Component, find, instantiate, Label, Node, ProgressBar } from 'cc';
import { UIBase } from '../Components/UIBase';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { ConfigKeys, GlobalData } from '../../../ScriptFrame/GlobalData';
import { AudioManager, AudioClipNames } from '../../../ScriptFrame/Frame/AudioManager';
import { showToast } from "db://assets/Module/UIFast";
const { ccclass, property } = _decorator;

@ccclass('FailPage')
export class FailPage extends UIBase {
    homeClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.HomePage)
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.GamePage)
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.FailPage)
    }
    replayClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        this.startGame()
    }
    async startGame(){
        find("UI/BundleLoading").active = true
        find("UI/BundleLoading/ProgressBar").getComponent(ProgressBar).progress = 0.5
        find("UI/BundleLoading/Text").getComponent(Label).string = "场景加载中"
        find("Scene/Parkings").children.forEach((child, index)=>{
            if (index < 4){
                child.name = "empty"
            }else{
                child.name = "lock"
                child.children[0].children[0].active = false
                child.children[0].children[1].active = true
            }
            child.children[1]?.destroy()
            child.children[1]?.removeFromParent()
        })
        find("Scene/Levels").destroyAllChildren()
        find("Scene/Levels").removeAllChildren()
        CarColorsGlobalInstance.instance.roleSysterm.clearAll()
        CarColorsGlobalInstance.instance.carSysterm.clearAll()
        CarColorsGlobalInstance.instance.bundleSysterm.loadLevels(GlobalData.instance.getConfigData(ConfigKeys.GameSaveData).level).then((level)=>{
            const Level = instantiate(level)
            find("Scene/Levels").addChild(Level)
            for(let i = 0; i < Level.children.length;i++){
                CarColorsGlobalInstance.instance.carSysterm.addCar(Level.children[i])
            }
            CarColorsGlobalInstance.instance.roleSysterm.initLevel()
            CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.GamePage)
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.HomePage)
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.FailPage)
            find("UI/BundleLoading").active = false
        }).catch((err)=>{
            // console.log(err)
            showToast("关卡正在制作中")
            CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.HomePage)
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.GamePage)
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.FailPage)
        })
        AudioManager.instance.playOneShot(AudioClipNames.start)
    }
}


