import { _decorator, Component, Node } from 'cc';
import { UIBase } from '../Components/UIBase';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { PlatformManager } from '../../../ScriptFrame/Frame/platformManager';
import { AudioManager, AudioClipNames } from '../../../ScriptFrame/Frame/AudioManager';
const { ccclass, property } = _decorator;

@ccclass('RevivePage')
export class RevivePage extends UIBase {
    reviveClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        PlatformManager.instance.showVideoAd(()=>{
            CarColorsGlobalInstance.instance.roleSysterm.refreshRoleLine()
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RevivePage)
            AudioManager.instance.playOneShot(AudioClipNames.upgrade)
        },()=>{
            CarColorsGlobalInstance.instance.toastSysterm.showToast("视频播放未完成！")
        })
    }
    closeClick(){
        AudioManager.instance.playOneShot(AudioClipNames.button_ok)
        CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.FailPage)
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RevivePage)
    }
}


