import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";

const { ccclass, property } = _decorator;

@ccclass('PrizePanel')
export class PrizePanel extends Panel {
    static skin: string = "PrizePanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) closeBtn: Node = null;

    @property(Sprite) img: Sprite = null;
    @property(Label) prizeName: Label = null;

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.closeBtn.on(Button.EventType.CLICK, this.cancel, this);
    }

    start(): void {
        const { optionImg, optionName } = this.data;
        this.img.spriteFrame = optionImg;
        this.prizeName.string = optionName;
    }

    cancel = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

    ok = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

}


