import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";
import { changeScene } from "db://assets/core/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import store from "db://assets/Scripts/store/store";

const { ccclass, property } = _decorator;

@ccclass('OverPanel')
export class OverPanel extends Panel {
    static skin: string = "OverPanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) closeBtn: Node = null;
    @property(Label) tip: Label = null;
    @property(Label) tip2: Label = null;

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.closeBtn.on(Button.EventType.CLICK, this.cancel, this);
    }

    start(): void {
        this.tip.string = `第${this.data.passLevel}关`;

        if (store.homeInfo.freeTimes) {
            this.tip2.string = `免费次数：${store.homeInfo.freeTimes}`;
        } else {
            this.tip2.string = `${store.homeInfo.gameCreditsEach}积分/次`;
        }

    }

    cancel = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

    ok = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
        changeScene(HomeScene);
    }

}


