import { _decorator, Button, Node } from "cc";
import Scene from "db://assets/core/Module/Scene";
import { changeScene, hideWaiting, showPanel, showWaiting } from "db://assets/core/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle } from "../Utils/Utils";
import { CarColorsGameEntry } from "db://assets/CarColorsGame/Scrips/CarColorsGameEntry";

const { ccclass, property } = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

  static bundle: string = "HomeScene";
  static skin: string = "HomeScene";
  // static group: string[] = ["HomeScene"];


  @property(Node) startBtn: Node = null;

  onLoad() {
    this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
  }

  async start() {
    showWaiting();
    await store.updateIndex();
    hideWaiting()

    const {
      firstEntryFlag,
    } = store.homeInfo || {};

  }

  @render
  render() {
    const {
      nickname = "",
    } = store.homeInfo || {};

  }



  clickStart = _asyncThrottle(async () => {
    changeScene(CarColorsGameEntry);
  });

}

