import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";
import { showShareGuide } from "db://assets/core/Module/UIFast";
import { MainGame } from "db://assets/Scripts/Scenes/MainGame/MainGame";
import gameStore from "db://assets/Scripts/store/gameStore";
import { _asyncThrottle } from "db://assets/Scripts/Utils/Utils";
import { CarColorsGlobalInstance } from "db://assets/Scripts/Scenes/MainGame/CarColorsGlobalInstance";
import store from "db://assets/Scripts/store/store";
import { LOG_TYPE, sendLog } from "db://assets/Scripts/Utils/WebNet/WebNet";

const { ccclass, property } = _decorator;

@ccclass('ReviewPanel')
export class ReviewPanel extends Panel {
    static skin: string = "ReviewPanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) cancelBtn: Node = null;
    @property(Node) closeBtn: Node = null;
    @property(Label) tip: Label = null;

    @property(SpriteFrame) shareSf: SpriteFrame = null;
    @property(SpriteFrame) exchangeSf: SpriteFrame = null;

    type: "share" | "green" | "credits" = "share";

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.cancelBtn.on(Button.EventType.CLICK, this.cancel, this);
        this.closeBtn.on(Button.EventType.CLICK, this.cancel, this);

        const lockIndex = MainGame.ins.getLockPoints();
        if (lockIndex == 4) {
            if (gameStore.startInfo.shareUnlocked) {
                this.type = "green";
                sendLog(LOG_TYPE.EXPOSURE, 16);
            } else {
                this.type = "share";
            }
        } else {
            this.type = "credits";
            sendLog(LOG_TYPE.EXPOSURE, 15);
        }

        console.log("解锁类型", this.type);

    }

    start(): void {
        const { type } = this;
        const { unparkQgNum, unparkCreditsNum } = store.homeInfo;

        this.okBtn.getComponent(Sprite).spriteFrame = type == "share" ? this.shareSf : this.exchangeSf;

        if (type == "share") {
            this.tip.string = "分享给好友复活\n并解锁1个车位";
        } else if (type == "green") {
            this.tip.string = `消耗${unparkQgNum}青果复活\n并解锁1个车位`;
        } else if (type == "credits") {
            this.tip.string = `消耗${unparkCreditsNum}积分复活\n并解锁1个车位`;
        }
    }

    cancel = _asyncThrottle(async () => {
        this.hidePanel();
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        await gameStore.submit(false);
    })

    ok = _asyncThrottle(async () => {
        const { type } = this;

        if(type == "credits"){
            sendLog(LOG_TYPE.CLICK, 15);
        }else if(type == "green"){
            sendLog(LOG_TYPE.CLICK, 16);
        }

        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        const lockIndex = MainGame.ins.getLockPoints();
        if (type == "share") {
            showShareGuide();
            this.scheduleOnce(() => {
                if (gameStore.startInfo.shareUnlocked) return;
                gameStore.startInfo.shareUnlocked = true;
                this.hidePanel();
                gameStore.unlockPark("share");
                MainGame.ins.unlockPoint(4);
                CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
            }, 5);
        } else {
            const suc = await gameStore.unlockPark(type);
            if (!suc) return;
            this.hidePanel();
            MainGame.ins.unlockPoint(lockIndex);
            CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
        }
    })

}


