import { _decorator, Component, Node, sys,find, CCString, AudioSource, Button, EventHandler } from 'cc';
import { CarColorsGlobalInstance } from './CarColorsGlobalInstance';
import { BundleCarColorsSysterm } from './Systerms/BundleCarColorsSysterm';
import { UICarColorsSysterm } from './Systerms/UICarColorsSysterm';
import { UINames } from './CarColorsGlobalTypes';
import { RoleCarColorsSysterm } from './Systerms/RoleCarColorsSysterm';
import { GlobalData, ConfigKeys } from '../../ScriptFrame/GlobalData';
import { CarCarColorsSysterm } from './Systerms/CarCarColorsSysterm';
import { AudioManager } from '../../ScriptFrame/Frame/AudioManager';
import Scene from "db://assets/core/Module/Scene";
const { ccclass, property } = _decorator;

@ccclass('CarColorsGameEntry')
export class CarColorsGameEntry extends Scene {

    static skin: string = "CarColors";
    // bundle: string = "CarColorsGame";

    async start() {

        this.initData()

        // 挂载资源包管理系统
        CarColorsGlobalInstance.instance.bundleSysterm = this.node.addComponent(BundleCarColorsSysterm)
        await CarColorsGlobalInstance.instance.bundleSysterm.loadBundles()

        // 挂载音频系统
        const clips = await Promise.all(CarColorsGlobalInstance.instance.bundleSysterm.loadAudioClips())
        AudioManager.instance.init(this.getComponent(AudioSource), clips)

        // 人物管理系统
        CarColorsGlobalInstance.instance.roleSysterm = this.node.addComponent(RoleCarColorsSysterm)
        await CarColorsGlobalInstance.instance.roleSysterm.loadRolePrefabs()

        // 汽车管理系统
        CarColorsGlobalInstance.instance.carSysterm = this.node.addComponent(CarCarColorsSysterm)

        // 挂载UI系统
        CarColorsGlobalInstance.instance.uiSysterm = this.node.addComponent(UICarColorsSysterm)
        await CarColorsGlobalInstance.instance.uiSysterm.loadUIPrefabs()

        CarColorsGlobalInstance.instance.uiSysterm.showUI(UINames.HomePage)
        find("UI/BundleLoading").active = false
    }

    initData(){
        let  gameSaveData: {level: number} = GlobalData.instance.getConfigData(ConfigKeys.GameSaveData)
        if (gameSaveData === null){
            gameSaveData = {
                level: 1
            }
        }
        GlobalData.instance.setConfigData(ConfigKeys.GameSaveData, gameSaveData)
    }
}


