import mobx from "mobx";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { showPanel, showToast } from "../../core/Module/UIFast";
import { getUrlParams } from "../Utils/WebNet/web/webTools";
import { AESDecrypt } from "../Utils/Crypto";
import { PREVIEW } from "cc/env";
import { NetTime } from "../NetTime";

const { makeAutoObservable } = mobx;


export interface IHomeInfo {
    creditsNum: number;
    signPopFlag: boolean;
    continueSignDays: number;
    nickname: string;
    avatar: string;
    newGetSpId: string;
    newGetSpName: string;
    newGetSpImage: string;
    luckBenefitDesc: string;
    benefitDesc: string;
    firstEntryFlag: boolean;
    rankInfos: {
        index: number;
        nickname: string;
        avatar: string;
    }[];
    rankPopList: {
        rankType: 1 | 2;
        openDate: string;
        index: number;
        prizeId: string;
        prizeName: string;
        prizeImage: string;
        count: number;
    }[];

    actStartTime: number;
    actEndTime: number;

    normalNum: number;
    goldNum: number;
    boolRankChange: boolean;

    currentPoolGoldNum: number;
    currentPoolNormalNum: number;

    remainCredits: number;

    boolJoinRank: boolean;

    eachLuckCredits: number;

    poolConfig: {
        normalNum: number;
        goldNum: number;
    };

    userId: string;

    currentMultiple: {
        doubleStartTime: number;
        doubleEndTime: number;
        rate: number;
        awardNormalNum: number;
        awardGoldNum: number;
    };

    // 当前体力配置
    currentEnergy: {
        initEnergy: number;
        energyLimit: number;
        eachEnergyTime: number;
        fullEnergyTime: number;
        exchangeEnergyConfigs: {
            creditNum: number;
            awardNum: number;
            id: number;
        }
    };

    taskCompletePops?: {
        taskCode: string;
        awardSpId: string;
        awardNum: number;
        times: number;
    }[];


    // 结算弹窗
    settlementPop?: {
        boolShowPop: boolean;
        oldRankMultiply: number;
        newRankMultiply: number;
        oldRankLevel: number;
        newRankLevel: number;
        rankList: {
            nickName: string;
            avatar: string;
            rankScore: number;
            boolMe: boolean;
            rankOrder:number;
        }[];
        obtainScoreNum: number;
    };

    // 瓜分弹窗
    dividePop?: {
        boolShowPop: boolean;
        creditsNum: number;
        rankOrder: number;
        rankMultiply: number;
        obtainScoreNum: number;
    };

    actRuleImage: string;
    lastPeriodSettlementTime: number;


    gradeValue: number,
    minJoinGrade: number,
}

export interface IRankPopInfo{
   // 结算弹窗
  settlementPop?: {
      boolShowPop: boolean;
      oldRankMultiply: number;
      newRankMultiply: number;
      oldRankLevel: number;
      newRankLevel: number;
      rankList: {
          nickName: string;
          avatar: string;
          rankScore: number;
          boolMe: boolean;
          rankOrder:number;
      }[];
      obtainScoreNum: number;
  };
}
class Store {

    frontVariable: { [key in string]: any } = {};

    async updateFrontVariable() {
        const { success, data } = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        actEndTime: 0,
        actStartTime: 0,
        avatar: "",
        benefitDesc: "",
        boolJoinRank: false,
        lastPeriodSettlementTime: 0,
        continueSignDays: 0,
        creditsNum: 0,
        currentEnergy: {
            eachEnergyTime: 0,
            energyLimit: 0,
            exchangeEnergyConfigs: { awardNum: 0, creditNum: 0, id: 0 },
            fullEnergyTime: 0,
            initEnergy: 0
        },
        currentMultiple: { awardGoldNum: 0, awardNormalNum: 0, doubleEndTime: 0, doubleStartTime: 0, rate: 0 },
        currentPoolGoldNum: 0,
        currentPoolNormalNum: 0,
        eachLuckCredits: 0,
        firstEntryFlag: false,
        goldNum: 0,
        luckBenefitDesc: "",
        newGetSpId: "",
        newGetSpImage: "",
        newGetSpName: "",
        nickname: "",
        normalNum: 0,
        poolConfig: { goldNum: 0, normalNum: 0 },
        rankInfos: [],
        rankPopList: [],
        remainCredits: 0,
        signPopFlag: false,
        boolRankChange: false,
        userId: "",
        actRuleImage:"",
        gradeValue: 1,
        minJoinGrade: 0,
    };

    updateId = 0;
    rankPopInfo:IRankPopInfo={
      settlementPop: {
        boolShowPop: false,
        oldRankMultiply: 0,
        newRankMultiply: 0,
        oldRankLevel: 0,
        newRankLevel: 0,
        rankList: [{
          nickName: "",
          avatar: "",
          rankScore: 0,
          boolMe: false,
          rankOrder:0,
      }],
        obtainScoreNum: 0,
    },
    }
    async updateIndex() {
        const { success, data, timeStamp } = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }

        NetTime.ins.setTime(timeStamp);
        this.homeInfo = data;
        this.updateId++;

    }

    ruleInfo: string = "";
    async updateRule() {
        const { success, data } = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    async updateEnergy() {
        const { success, data, timeStamp } = await sendWebNet(WebNetName.energyDetail);
        NetTime.ins.setTime(timeStamp);
        if (!success) {
            return;
        }
        this.homeInfo.currentEnergy = data.currentEnergy;
        this.homeInfo.remainCredits = data.remainCredits;
        this.updateId++;
    }


    checkActTime = (isAllow = false) => {

        const { actStartTime, actEndTime } = this.homeInfo || {};

        if (actStartTime > NetTime.now()) {
            console.log("活动未开始");
            showToast("活动未开始");
            return false;
        }
        if (actEndTime < NetTime.now() && !isAllow) {
            console.log("活动已结束");
            showToast("活动已结束");
            return false;
        }
        // console.log("checkActTime");

        return true;
    };

    enter: boolean = false;
    async doAssist() {
        const inviteCode = getUrlParams("inviteCode");
        if (!inviteCode) return;

        this.enter = true;

        const { success, data } = await sendWebNetWithToken(WebNetName.doAssist, { inviteCode });
        if (!success) return;

        showToast(data.extra);
    }

    setRankPopInfo(rankInfo){
        this.rankPopInfo.settlementPop = rankInfo;
        // console.log("setRankPopInfo",this.rankPopInfo);

    }
}


const store: Store = makeAutoObservable(new Store());

export default store;
