import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from 'cc';
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
import Panel from "db://assets/core/Module/Panel";
import { CarColorsGlobalInstance } from "db://assets/Scripts/Scenes/MainGame/CarColorsGlobalInstance";
import store from "db://assets/Scripts/store/store";
import gameStore from "db://assets/Scripts/store/gameStore";
import { _asyncThrottle } from "db://assets/Scripts/Utils/Utils";

const { ccclass, property } = _decorator;

@ccclass('UnlockPanel')
export class UnlockPanel extends Panel {
    static skin: string = "UnlockPanel";
    static bundle: string = "GamePanel";

    @property(Node) okBtn: Node = null;
    @property(Node) cancelBtn: Node = null;
    @property(Node) closeBtn: Node = null;
    @property(Label) tip: Label = null;

    @property(SpriteFrame) shareSf: SpriteFrame = null;
    @property(SpriteFrame) exchangeSf: SpriteFrame = null;

    onLoad() {
        super.onLoad();
        this.okBtn.on(Button.EventType.CLICK, this.ok, this);
        this.cancelBtn.on(Button.EventType.CLICK, this.cancel, this);
        this.closeBtn.on(Button.EventType.CLICK, this.cancel, this);
    }

    start(): void {
        const { type } = this.data;
        const { unparkQgNum, unparkCreditsNum } = store.homeInfo;

        this.okBtn.getComponent(Sprite).spriteFrame = type == "share" ? this.shareSf : this.exchangeSf;

        if (type == "share") {
            this.tip.string = "分享好友\n即可解锁1个车位";
        } else if (type == "green") {
            this.tip.string = `消耗${unparkQgNum}青果\n即可解锁1个车位`;
        } else if (type == "credits") {
            this.tip.string = `消耗${unparkCreditsNum}积分\n即可解锁1个车位`;
        }
    }

    hidePanel() {
        super.hidePanel();
        CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
    }

    cancel = () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        this.hidePanel();
    }

    ok = _asyncThrottle(async () => {
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);

        const { type, onSuccess } = this.data;
        const suc = await gameStore.unlockPark(type);
        if (!suc) return;

        this.hidePanel();
        onSuccess?.();

    })

}


