import mobx from "mobx";
import { assetManager, ImageAsset, SpriteFrame, Texture2D } from "cc";
import { getUrlParams } from "../Utils/WebNet/web/webTools";
import { sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
import store from "./store";
import {showShareGuide, showToast} from "../../core/Module/UIFast";

const { makeAutoObservable } = mobx;

class ShareStore {

    inviteInfo: {
        shareUrl: string,
        inviteCode: string,
        qrCode: string | SpriteFrame,
    } = {
        shareUrl: "",
        inviteCode: "",
        qrCode: "",
    };

    async genInviteInfo() {

    }

    doShare(showGuide = true) {

        if(showGuide){
            showShareGuide();
        }

        const { title, content, thumbnail } = store.frontVariable?.shareInfo || {};
        const actLink = location.origin + location.pathname + `?appID=${getUrlParams("appID")}`;

        const param = {
            data: {
                title, // 标题
                desc: content, // 描述
                imgUrl: thumbnail, // 图片
                link: actLink // 链接
            }
        }
        console.log("postMessage参数", param);

        // @ts-ignore
        wx.miniProgram.postMessage(param);
    }

}

const shareStore: ShareStore = makeAutoObservable(new ShareStore());

export default shareStore;
