import mobx from "mobx";
import { creditsCost, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { AESDecrypt, AESEncrypt } from "../Utils/Crypto";
import {
    hideGlobalDisable,
    hideWaiting,
    showGlobalDisable,
    showPanel,
    showToast,
    showWaiting
} from "../../core/Module/UIFast";
import store, { IHomeInfo } from "./store";
import { prefixInteger } from "../Utils/Utils";
import { NetTime } from "../NetTime";

const { makeAutoObservable } = mobx;

export interface IStartInfo {
    barrierFlag: boolean,      // 本局游戏难度是否上升
    firstGameFlag: boolean,     // 本局是否第一局，为true则有一，二，无尽模式三个阶段的区别
    accumulateLuckNum: number,     // 当局累计获得福袋数量
    initScore: number,     // 当局初始分数值
    limitLuckNum: number,     // 当日上限可获得福袋数
    downArea: string[],     // 掉落分布，集合，比如每日上限6个，这里配置返回1、2、3
    currentAcquireNum: number,     // 当局剩余可获得福袋数，不包含accumulateLuckNum，当局累计获得福袋数量
    currentStage: 1 | 2 | 3,     // 当前应该进入的阶段(1-一阶段 2-二阶段 3-无尽模式)
    startId: number,    // 游戏记录ID
    slideScore: number,    // 校验滑块的分数值
    eachUseLimitTimes: number //每局可使用道具限制数量
}

export interface IPutLuckData {
    drawOrderNo: number | string,
    currentPoolNormalNum: number
    currentPoolGoldNum: number,
}


let id = 0;

// 生成32位uuid
function uuid() {
    return `xxxx-xxxx-xxxx-xxxx-xxxx-xxxx-${prefixInteger(id++ % 100, 2)}`.replace(/[x]/g, function (c) {
        const r = Math.random() * 16 | 0;
        return r.toString(16);
    });
}


class GameStore {

    async putLuck(): Promise<IPutLuckData> {
        if (store.homeInfo.currentEnergy.initEnergy <= 0) {
            showToast("体力不足");
            store.updateEnergy();
            return null;
        }

        const params: {ticketNum?: any} = {};

        if (store.homeInfo.normalNum <= 0) {
            return;
        }

        // showWaiting();
        showGlobalDisable();
        const { success, data } = await sendWebNet(WebNetName.putLuck, params);
        // hideWaiting();
        hideGlobalDisable();

        if (!success) {
            return null;
        }

        let decrypt = data;
        try {
            decrypt = JSON.parse(AESDecrypt(decrypt, "6FDCE02EBB43C3A8", "cDOiBC1n2QrkAY2P"));
        } catch (e) {
            console.log("解析失败", e);
        }

        store.homeInfo.currentEnergy.initEnergy--;
        if (store.homeInfo.currentEnergy.initEnergy % 5 === 0) {
            store.updateEnergy();
        }

        store.homeInfo.normalNum = decrypt.normalNum;
        store.homeInfo.goldNum = decrypt.goldNum;

        // console.log(decrypt);
        return decrypt;
    }

    async report({ lossGoldNum, lossNormalNum, acquireGoldNum, acquireNormalNum }) {
        const { success: timeSuc, data: timestamp = Date.now() } = await sendWebNet(WebNetName.currentTime);

        if (!timeSuc) {
            return null;
        }

        NetTime.ins.setTime(timestamp);

        const param = {
            lossGoldNum, lossNormalNum, acquireGoldNum, acquireNormalNum,
            uniqueOrderNo: uuid(),
            timestamp,
        };

        console.log("上报", param);

        const encrypt = AESEncrypt(JSON.stringify(param), "6FDCE02EBB43C3A8", "cDOiBC1n2QrkAY2P");

        const { success, data } = await sendWebNet(WebNetName.reportResult, { param: encrypt }, {
            isGet: false,
        });

        if (!success) {
            return null;
        }

        let decrypt = data;
        try {
            decrypt = JSON.parse(AESDecrypt(decrypt, "6FDCE02EBB43C3A8", "cDOiBC1n2QrkAY2P"));
        } catch (e) {
            console.log("解析失败", e);
        }

        store.homeInfo.normalNum = decrypt.normalNum;
        store.homeInfo.goldNum = decrypt.goldNum;

        // console.log(decrypt);
        return decrypt;
    }


}


const gameStore: GameStore = makeAutoObservable(new GameStore());

export default gameStore;
