import { _decorator, Component, Node } from 'cc';
import { CarColorsGlobalInstance } from '../CarColorsGlobalInstance';
import { UINames } from '../CarColorsGlobalTypes';
import { UIBase } from '../Components/UIBase';
import { PlatformManager } from '../../../ScriptFrame/Frame/platformManager';
import { showToast } from "db://assets/core/Module/UIFast";
import { AudioClipName, AudioMgr } from "db://assets/core/base/AudioMgr";
const { ccclass, property } = _decorator;

@ccclass('RefreshPage')
export class RefreshPage extends UIBase {
    useClick(){
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        PlatformManager.instance.showVideoAd(()=>{
            CarColorsGlobalInstance.instance.carSysterm.refreshCar()
            CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RefreshPage)
            CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
            AudioMgr.ins.playOneShot(AudioClipName.upgrade);
        },()=>{
            showToast("视频播放未完成！")
        })
    }
    closeClick(){
        AudioMgr.ins.playOneShot(AudioClipName.button_ok);
        CarColorsGlobalInstance.instance.uiSysterm.hideUI(UINames.RefreshPage)
        CarColorsGlobalInstance.instance.roleSysterm.isGaming = true
    }
}


