import { reqDbLogin } from "../../db_api/index";
import { createUrl, wxLogin } from "../../utils/util";

//获取应用实例
const app = getApp()
Page({
  data: {
    hasPhoneInfo: false,
    isAgree: false,
  },
  options: {},

  onLoad: async function (options) {
    console.log('phoneLogin options', options)
    this.options = options;
  },

  // 从基础库 2.21.2 开始，对获取手机号的接口进行了安全升级，以下是新版本接口使用指南。
  // （旧版本接口目前可以继续使用，但建议开发者使用新版本接口，以增强小程序安全性）
  async getPhoneNumber(e) {
    console.log('e.detail', e.detail)
    wx.showLoading({
      title: "加载中...",
      mask: true
    })
    const {
      errMsg,
      code,
      encryptedData,
      iv
    } = e.detail
    if (errMsg == 'getPhoneNumber:ok') { //这里表示获取授权成功
      this.setData({
        hasPhoneInfo: true,
      })

      const res = await wxLogin();
      if (res.code) {
        const loginRes = await reqDbLogin({
          data: {
            code: res.code,
            redirect: decodeURIComponent(this.options.redirect),
            phoneEncryptedData: encryptedData,
            phoneIv: iv
          }
        })
        if (loginRes.success && loginRes.data?.isBindPhone) {
          wx.redirectTo({
            url: createUrl('/pages/webview/webview', this.options)
          });
        }
      }
    } else {
      wx.showToast({
        title: '授权手机号失败',
        icon: 'none',
        duration: 2000
      })
    }
  },

  checkboxChange() {
    this.setData({
      isAgree: !this.data.isAgree,
    })
  },

  judgeAgree() {
    wx.showToast({
      title: "请先阅读并同意协议",
      icon: "none",
    });
  },

  showPrivacy() {
    wx.navigateTo({
      url: '/pages/privacy/privacy',
    })
  },

  cancel() {
    // wx.navigateBack({
    //   delta: 1
    // });
    wx.redirectTo({
      url: createUrl('/pages/index/index', this.options)
    })
  }

})