// webview.js
// 获取应用实例
const DEFAULT_PROJECT = {
  'test': {
    redirectUrl: 'https://activity.m.duibatest.com.cn/projectx/p94791461/index.html?appID=19487',
    loginDomain: "https://activity.m.duibatest.com.cn"
  },
  'pre': {
    redirectUrl: 'https://99183-activity.dexfu.cn/projectx/pe08eb0d1/index.html?appID=99183',
    loginDomain: "https://99183-activity.dexfu.cn"
  },
  'prod': {
    redirectUrl: 'https://99183-activity.dexfu.cn/projectx/TODO/index.html?appID=99183',
    loginDomain: "https://99183-activity.dexfu.cn"
  },
}

Page({
  data: {
    // 分享信息
    h5ShareInfo: {
      title: '',
      imgUrl: '',
      link: ''
    },
  },
  env: 'pre', // TODO 'test', 'pre', 'prod'
  redirectUrl: '',
  options: {},
  onLoad(options) {
    this.initWebView(options)
  },
  async initWebView(options) {
    console.log("options:", options)
    this.options = options;
    let {
      env,
      redirect,
      isNeedLogin = '1',
    } = this.options || {}

    if (env) this.env = env;
    console.log('DEFAULT_PROJECT[env]', this.env, DEFAULT_PROJECT[this.env])
    let redirectUrl = redirect ? decodeURIComponent(redirect) : DEFAULT_PROJECT[this.env]?.redirectUrl;
    this.redirectUrl = redirectUrl

    if (isNeedLogin == '1') {
      wx.login({
        success: async (res) => {
          console.log(111, res)
          if (res.code) {
            const loginUrl = `${DEFAULT_PROJECT[this.env]?.loginDomain}/wechat/wine/autoLogin`
            console.log('免登接口：', loginUrl)
            wx.request({
              url: loginUrl,
              data: {
                code: res.code,
                redirect: redirectUrl
              },
              method: 'POST',
              success: res => {
                console.log('login', res)
                if (res.statusCode == 200) {
                  this.setData({
                    path: res.data?.data?.redirectUrl,
                  })
                } else {
                  wx.showToast({
                    title: '登录失败',
                    icon: 'none',
                    duration: 4000
                  })
                }
              },
              fail: err => {
                // console.log(err);
              },
              complete: res => {
                // console.log(res);
              }
            });
          }
        }
      })
    } else if (redirectUrl) {
      this.setData({
        path: redirectUrl,
      })
    }
  },

  getMessage(e) {
    const {
      data
    } = e.detail;
    console.log("getMessage----", data)
    if (data) {
      this.setData({
        h5ShareInfo: data[data.length - 1]
      })
    }
  },

  onShareAppMessage: function (options) { //分享
    const { h5ShareInfo } = this.data;
    console.log("onShareAppMessage--------", JSON.stringify(options))
    const shareUrl = `pages/dbindex/dbindex?env=${this.env}&isNeedLogin=1&redirect=${encodeURIComponent(
      h5ShareInfo.link || this.redirectUrl
    )}`;

    return {
      title: h5ShareInfo.title,
      path: shareUrl,
      imageUrl: h5ShareInfo.imgUrl,
      success: function (res) {
        console.log(res, '成功')
        // wx.showToast({
        //   title: '分享成功',
        //   icon: 'none'
        // })
        // 转发成功
      },
      fail: function (res) {
        console.log(res + '失败');
        // 转发失败
      },
      complete: function (res) {
        // 不管成功失败都会执行
        console.log(res, '成功或失败');
      }
    }

  },


})
