// webview.js
import { default_rUrl, reqDbLogin } from "../../db_api/index";
import { wxLogin } from "../../utils/util";

// 获取应用实例
Page({
  data: {
    // 分享信息
    h5ShareInfo: {
      title: '',
      imgUrl: '',
      link: ''
    },
  },
  redirectUrl: '',
  options: {},
  onLoad(options) {
    this.initWebView(options)
  },
  async initWebView(options) {
    console.log("options:", options)
    this.options = options;
    let {
      redirect,
      isNeedLogin = '1',
    } = this.options || {}

    let redirectUrl = redirect ? decodeURIComponent(redirect) : default_rUrl;
    this.redirectUrl = redirectUrl

    if (isNeedLogin == '1') {
      const res = await wxLogin();
      if (res.code) {
        const loginRes = await reqDbLogin({
          data: {
            code: res.code,
            redirect: this.redirectUrl
          }
        })
        if (loginRes.success) {
          this.setData({ path: loginRes?.data?.redirectUrl })
        } else {
          wx.showToast({
            title: '登录失败',
            icon: 'none',
            duration: 4000
          })
        }
      }
    } else if (this.redirectUrl) {
      this.setData({
        path: this.redirectUrl,
      })
    }
  },

  getMessage(e) {
    const {
      data
    } = e.detail;
    console.log("getMessage----", data)
    if (data) {
      this.setData({
        h5ShareInfo: data[data.length - 1]
      })
    }
  },

  onShareAppMessage: function (options) { //分享
    const { h5ShareInfo } = this.data;
    console.log("onShareAppMessage--------", JSON.stringify(options))
    const shareUrl = `pages/index/index?isNeedLogin=1&redirect=${encodeURIComponent(
      h5ShareInfo.link || this.redirectUrl
    )}`;

    return {
      title: h5ShareInfo.title,
      path: shareUrl,
      imageUrl: h5ShareInfo.imgUrl,
      success: function (res) {
        console.log(res, '成功')
        // wx.showToast({
        //   title: '分享成功',
        //   icon: 'none'
        // })
        // 转发成功
      },
      fail: function (res) {
        console.log(res + '失败');
        // 转发失败
      },
      complete: function (res) {
        // 不管成功失败都会执行
        console.log(res, '成功或失败');
      }
    }

  },


})
