import { default_rUrl, reqDbLogin } from "../../db_api/index";
import { createUrl, wxLogin } from "../../utils/util";

Page({
  data: {
  },
  isBindPhone: false,
  options: {},
  async onLoad(options) {
    console.log('页面参数', options)
    // options 参数：
    // redirect,
    // isNeedLogin,
    // channel,
    const channel = options.channel || '0';
    this.options = {
      ...options,
      channel,
      redirect: encodeURIComponent((options.redirect ? decodeURIComponent(options.redirect) : default_rUrl) + (channel ? `&channel=${channel}` : ''))
    };
    this.isLogin();
  },
  onShow() {
  },
  async isLogin() {
    const res = await wxLogin();
    if (res.code) {
      const loginRes = await reqDbLogin({
        data: {
          code: res.code,
          redirect: decodeURIComponent(this.options.redirect)
        }
      })
      if (loginRes.success && loginRes.data?.isBindPhone) {
        this.isBindPhone = true;
        this.goAct();
      } else {
        this.isBindPhone = false;
      }
    }
  },
  goAct() {
    if (!this.isBindPhone) {
      wx.navigateTo({
        url: createUrl('/pages/phoneLogin/phoneLogin', this.options)
      })
      return;
    }
    wx.redirectTo({
      url: createUrl('/pages/webview/webview', this.options)
    });
  },

})