const formatTime = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return `${[year, month, day].map(formatNumber).join('/')} ${[hour, minute, second].map(formatNumber).join(':')}`
}

const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : `0${n}`
}

const wxLogin = () => {
  return new Promise((resolve, reject) => {
    wx.login({
      success: res => {
        console.log('wxLogin success: ', res)
        resolve(res);
      },
      fail: err => {
        reject(err);
      }
    })
  });
}
export let createUrl = (baseUrl, params) => {
  let paramsStr = ''
  // 是否需要编码前缀
  let prefix = 'EN_';
  for (let key in params) {
    // 值为null或者undefined不传改参数
    if (params[key] !== null && params[key] !== undefined && params[key] !== '') {
      paramsStr += paramsStr ? '&' : '';
      let value = params[key];
      // 处理需要编码的key-value
      if (key.indexOf(prefix) > -1) {
        key = key.replace(prefix, '');
        value = encodeURIComponent(value);
      }
      paramsStr += `${key}=${value}`;
    }
  }
  if (!baseUrl) { return paramsStr };
  if (!paramsStr) { return baseUrl };

  let subStr = '';
  // 没有问号
  if (baseUrl.lastIndexOf('?') === -1) {
    subStr = '?';
  } else {
    // 最后一个字符
    const lastChar = baseUrl.slice(-1);
    // 如果最后接在最后一个字符不是? 则加上一个&
    if (lastChar !== '&' && lastChar !== '?') {
      subStr = '&';
    }
  }
  return baseUrl + subStr + paramsStr;
}

module.exports = {
  wxLogin,
  createUrl,
  formatTime
}
