import React, { Component } from 'react';
import './lightedPop.less';
import { observer } from 'mobx-react';
import store from '../../store';
import modalStore from '../../store/modal';
import skinStore from '../../store/newSkin';
import { SvgaPlayer } from '../SvgaPlayer';
@observer
class LightedPop extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
  }

  handleClose() {
    modalStore.closePop("LightedPop")
  }
  render() {
    const { lightedPop, common, svga } = skinStore
    const { bg, know_btn, deng } = lightedPop
    const { close } = common
    const { pop, light } = svga

    const { name, desc, icon } = this.props.popData || {}

    return <div className="lightedPop modal_center">
      <SvgaPlayer className="light" src={light} />
      <SvgaPlayer className="pop" src={pop} />
      <span className="bg" style={{ backgroundImage: `url(${bg})` }} ></span>
      <div className="title">{name}</div>
      <div className="desc">{desc}</div>
      <span className="deng" style={{ backgroundImage: `url(${deng})` }} ></span>
      <img className="icon" src={icon} alt="" />
      <div className="name">{name}</div>
      <span className="close" onClick={this.handleClose} style={{ backgroundImage: `url(${close})` }} />
      <span className="know_btn" onClick={this.handleClose} style={{ backgroundImage: `url(${know_btn})` }} />
    </div>
  }
}
export default LightedPop;