export const PAGE_MAP = {
  HOME_PAGE: 'homePage',
  PRIZE_PAGE: 'prizePage',
  FUTURE_PAGE: 'futurePage',
}

export const errMessageMap = {
  200009: "奖品已抢完，明天再来吧～",
  200002: "请刷新页面，奖品库存已领完～",
}

// 勋章类型(1:活动勋章 2:荣誉勋章)
export const MEDAL_TYPE = {
  /** 活动勋章 */
  ACTIVITY: 1,
  /** 荣誉勋章 */
  HONOR: 2,
}

/**
 * 本次投放：
 * 1、官微菜单栏
 * 2、官微权益中心
 * 3、寿险小程序
 * 4、官微推文
 * 5、太好钉
 * 6、海报
 */
/**
 * 渠道参数
 * 1.官微菜单栏 guanwei
 * 2.官微权益中心 quanyizhongxin
 * 3.寿险小程序 shouxian
 * 4.官微推文 tuiwen
 * 5.长航加油站 dingdong
 * 6.太好钉 taihaoding
 * 7.海报 haibao
 * 8.太好店小程序
 * 9.官微服务大厅
 * 10.集团app
 * 11.订阅号
 */
export const CHANNEL_PARAMS = {
  /** 官微菜单栏 */
  GW_MENU: 'guanwei',
  /** 官微权益中心 */
  GW_EQUITY: 'quanyizhongxin',
  /** 寿险小程序 */
  SHOUXIAN_MINI: 'shouxian',
  /** 官微推文 */
  GW_TWEET: 'tuiwen',
  /** 长航加油站（公众号） */
  CHANG_HANG: 'dingdong',
  /** 太好钉 */
  THD: 'taihaoding',
  /** 海报 */
  POSTER: 'haibao',
  /** 太好店小程序 */
  THD_MINI: 'taihaodian',
  /** 官微服务大厅 */
  FUWU: 'fuwu',
  /** 集团app */
  APP: 'app',
  /** 心意商城小程序 */
  XINYI: 'xinyi',
  /** 年报活动 */
  NIANBAO: 'nianbao',
  /** 订阅号 */
  DINGYUE: 'dingyue',
}

/** 神策 sysSourceName渠道参数 */
export const SYS_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: '官微',
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: '官微',
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: '官微',
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: '官微',
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: '个险',
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: '官微',
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: '官微',
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: '个险',
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: '官微',
  /** 集团app */
  [CHANNEL_PARAMS.APP]: '官微',
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: '官微',
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: '官微',
  /** 订阅号 */
  [CHANNEL_PARAMS.DINGYUE]: '官微'
}

/** 神策 activitySource渠道参数 */
export const ACTIVITY_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: '官微菜单栏',
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: '官微权益中心',
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: '寿险小程序',
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: '官微推文',
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: '长航加油站',
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: '太好钉',
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: '海报',
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: '太好店小程序',
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: '官微服务大厅',
  /** 集团app */
  [CHANNEL_PARAMS.APP]: '集团app',
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: '心意商城小程序',
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: '年报活动',
  /** 订阅号 */
  [CHANNEL_PARAMS.NIANBAO]: '订阅号'
}

export const EVENT_TYPE = {
  CLICK: "click",
  BROWSE: "browse",
}
