import React, { Component } from 'react';
import './rulePop.less';
import { observer } from 'mobx-react';
import store from '../../store';
import modalStore from '../../store/modal';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import skinStore from '../../store/newSkin';
import { SvgaPlayer } from '../SvgaPlayer';
@observer
class RulePop extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    sensorMdExpouse("xcxPopupExpouse", { pageName: `退出挽留弹窗` })
  }

  handleClose() {
    sensorMdClick("xcxPopupClick", { pageName: `退出挽留弹窗`, buttonName: '继续评估' })
    modalStore.closePop("RulePop")
  }
  render() {
    const { rulePop, common, svga } = skinStore
    const { bg } = rulePop
    const { close } = common
    const { pop, light } = svga
    const { rule } = store.indexInfo?.activityBaseInfo || {};

    return <div className="rulePop modal_center">
      <SvgaPlayer className="light" src={light} />
      <SvgaPlayer className="pop" src={pop} />
      <span className="bg" style={{ backgroundImage: `url(${bg})` }} ></span>
      <div className="content" dangerouslySetInnerHTML={{ __html: rule }}></div>
      <span className="close" onClick={this.handleClose} style={{ backgroundImage: `url(${close})` }} />
    </div>
  }
}
export default RulePop;