import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import postcssPluginPx2rem from "postcss-plugin-px2rem"
import { viteMockServe } from 'vite-plugin-mock'
import fs from 'fs';
import path, {resolve} from 'path'
import legacy from '@vitejs/plugin-legacy';
import { createHtmlPlugin } from 'vite-plugin-html'

// 使用模板的话需要对html模版进行一些处理，加一些占位符
const newParams = {
  minify:true,
  pages:[
    // 第一个页面的配置
    {
      filename: "index.html",
      template: "./index.html",
      entry: "./src/main.jsx",
    },
  ]
}


//配置参数 
const px2remOptions = {
  rootValue: 100,  //换算基数， 默认100 ,也就是1440px ，这样的话把根标签的字体规定为1rem为50px,这样就可以从设计稿上量出多少个px直接在代码中写多少px了
  unitPrecision: 5, //允许REM单位增长到的十进制数字，其实就是精度控制
  // propWhiteList: [], // 默认值是一个空数组，这意味着禁用白名单并启用所有属性。
  // propBlackList: [], // 黑名单
  // exclude:false,  //默认false，可以（reg）利用正则表达式排除某些文件夹的方法，例如/(node_module)/ 。如果想把前端UI框架内的px也转换成rem，请把此属性设为默认值
  // selectorBlackList: [], //要忽略并保留为px的选择器
  // ignoreIdentifier: false, //（boolean/string）忽略单个属性的方法，启用ignoreidentifier后，replace将自动设置为true。
  // replace: true, // （布尔值）替换包含REM的规则，而不是添加回退。
  mediaQuery: false, //（布尔值）允许在媒体查询中转换px
  minPixelValue: 0  //设置要替换的最小像素值(3px会被转rem)。 默认 0
}


// https://vitejs.dev/config/
export default defineConfig({
  define:{
    __BUILD_TIME__: JSON.stringify(Date.now())
  },
  base: './',
  plugins: [
    react({
      babel: {
        plugins: [
          ["@babel/plugin-proposal-decorators", { legacy: true }],
          ["@babel/plugin-proposal-class-properties", { loose: true }],
        ],
      },
    }),
    viteMockServe({
      mockPath: 'mock',          //mock文件路径，在根路径下创建一个mock文件
      // 是否实时更新
      watchFiles: true,
      localEnabled: true, //mock开关
      prodEnabled: false,         //生产环境下为false，这样就不会被打包到生产包中
      ignore: /^\_/,       //忽略开始_路径
    }),
    legacy(),
    createHtmlPlugin(newParams)
  ],
  css: {
    postcss: {
      plugins: [postcssPluginPx2rem(px2remOptions)]
    },
    preprocessorOptions: {
      less: {
        javascriptEnabled: true, // 支持内联 JavaScript
        modifyVars: { // 更改主题
        }
      }
    }
  },
  server: {
    host: true,
    proxy: {
      '/api': {
        target: 'https://unionpay-task.duibatest.com.c/api',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, '')
        // 其他可选配置项
      }
    }
  },
  build: {
    target: "es2015",
    rollupOptions: {
      input: {
        'index': './src/main.jsx',
      },
    },
  },
})
