import React, { Component } from 'react';
import './futurePage.less';
import { _asyncThrottle, _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import store from '../../store';
import { PAGE_MAP } from '../../utils/constants';
import { observer } from 'mobx-react';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import { futureActivityApi } from '../../api/api';
import modalStore from '../../store/modal';
@observer
class FuturePage extends Component {
  constructor(props) {
    super(props);

    this.state = {
      activityList: [],
    }

  }

  async componentDidMount() {
    sensorMdExpouse("xcxPage", { pageName: `未来展品` })
    const res = await futureActivityApi({
      channel: CFG.channel
    });
    if (res.ok) {
      this.setState({ activityList: res.data?.activityInfoList || [] })
    }
  }

  // 显示长图弹窗
  showLongImgPop = _asyncThrottle((item) => {
    modalStore.pushPop("LongImgPop", { img: item.previewPage })
  })

  // 切换tab
  toggleTab = _asyncThrottle((index) => {
    this.setState({ curTab: index })
  })

  // 返回
  backHandle = _asyncThrottle(() => {
    sensorMdClick("xcxClick", { pageName: `未来展品`, buttonName: '返回' })
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { prize_img_bg, title, item_bg, btn } = skinStore.futurePage;
    const { back, sub_page_bg_cover, sub_page_bg } = skinStore.common;
    const { activityList } = this.state;
    return (
      <div className="futurePage">
        <div className="bg" style={{ 'backgroundImage': `url(${sub_page_bg})` }}></div>
        {/* 返回 */}
        <div className="back" onClick={this.backHandle} style={{ 'backgroundImage': `url(${back})` }}></div>
        {/* 遮罩 */}
        <div className="bg_cover" style={{ 'backgroundImage': `url(${sub_page_bg_cover})` }}></div>
        {/* 标题 */}
        <div className="title" style={{ 'backgroundImage': `url(${title})` }}></div>
        {/* 活动列表 */}
        <div className="act_list">
          {activityList.map((item, index) => (
            <div className="prize_item" key={index} onClick={() => this.showLongImgPop(item)} style={{ 'backgroundImage': `url(${item_bg})` }}>
              <div className="prize_img_box" style={{ 'backgroundImage': `url(${prize_img_bg})` }}>
                <img className="prize_img" src={item.thumbnail} alt="" />
              </div>
              <div className="prize_info">
                <div className="prize_name">{item.name}</div>
                <div className="prize_desc">{item.introduction}</div>
              </div>
              <div className="btn" style={{ 'backgroundImage': `url(${btn})` }}></div>
            </div>
          ))}
        </div>
      </div>
    );
  }
}

export default FuturePage;
