import React, { Component } from 'react';
import './index.less';
import { observer } from 'mobx-react';
import store, { skinId } from '../../store';
import { PAGE_MAP } from '../../utils/constants';
import modalStore from '../../store/modal';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
@observer
class WanLiuDialog extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    sensorMdExpouse("xcxPopupExpouse", { pageName: `退出挽留弹窗` })
  }

  tuiChuBtnFun() {
    sensorMdClick("xcxPopupClick", { pageName: `退出挽留弹窗`, buttonName: '退出' })
    store.changePage(PAGE_MAP.HOME_PAGE)
    modalStore.closePop("WanLiuDialog")
  }
  continueFun() {
    sensorMdClick("xcxPopupClick", { pageName: `退出挽留弹窗`, buttonName: '继续评估' })
    modalStore.closePop("WanLiuDialog")
  }
  render() {
    return <div className="wanLiuDialog modal_center">
      弹窗
    </div>
  }
}
export default WanLiuDialog;