import Mock from "mockjs"

export const homeJs = [
  {
    url: '/api/test', //请求地址
    method: 'post', //请求方式
    response: () => {
      return {
        code: 200,
        msg: 'ok',
        data: {
          task: 1
        }
      }
    },
  },
  {
    url: '/activity/index', //请求地址
    response: () => {
      const list = [
        "//yun.duiba.com.cn/polaris/medal1.c022287fcb0174d828077cb5cf9b9b299d128a6b.png",
        "//yun.duiba.com.cn/polaris/medal2.341cc76fa221193683be4944f19dd63e1e5eee70.png",
        "//yun.duiba.com.cn/polaris/medal3.cd7c88c280902662cf3634b06ad0365ff7d75628.png",
        "//yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png",
      ]
      return {
        "ok": true,
        "code": 200,
        "msg": 'nodano',
        "timestamp": +new Date(),
        "data": {
          "medalInfoList": new Array(27).fill(0).map((item, index) => {
            const type = index < 15 ? 1 : 2;
            return {
              "name": `${type == 1 ? '活动' : '荣誉'}勋章名称${index + 1}`,
              "desc": `${type == 1 ? '活动' : '荣誉'}勋章描述${index + 1}`,
              "icon": list[index % 4],
              "jumpUrl": "aute",
              "endTime": index == 0 ? +new Date() - 1000 * 60 * 60 * 24 * 30 : +new Date() + 1000 * 60 * 60 * 24 * 30,
              "startTime": +new Date() - 1000 * 60 * 60 * 24 * 30,
              "boolGet": index != 3,
              "medalId": `勋章id${index + 1}`,
              "medalType": type, // 勋章类型(1:活动勋章 2:荣誉勋章)
            }
          }),
          "newGetMedalInfoList": [
            {
              "medalId": "laboris sunt incididunt magna",
              "babyCredits": 12125148.969407722
            },
          ],
          "babyCredits": 6676,
          "activityBaseInfo": {
            "rule": "<p>以下是游戏规则：手速要快，点击红包雨。。333。。。。。。。。。。。。。。。。。。。。11111111111111sadasdadadsad555555555777777777779999999999991111111111111111111111122222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333333333333333333333333333333333331111111111111111111111111111111111111111111111111111111111111112222222222222222222222222222222222222222222222222222222222222223333333333333333333333333333333333333333333333333333333333333</p>",
            "startTime": +new Date() - 1000 * 60 * 60 * 24 * 30,
            "endTime": +new Date() + 1000 * 60 * 60 * 24 * 30
          }
        }
      }
    }
  },
  {
    url: '/activity/futureActivity', //请求地址
    response: () => {
      return {
        "ok": true,
        "code": 200,
        "msg": 'nodano',
        "timestamp": +new Date(),
        "data": {
          "activityInfoList": new Array(20).fill(0).map((item, index) => ({
            "name": `活动名称${index + 1}`,
            "introduction": `活动描述${index + 1}`,
            "thumbnail": `https://yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png`,
            "upTime": +new Date() + 1000 * index * 60 * 60 * 24 * 30,
            "previewPage": `https://yun.duiba.com.cn/polaris/1.7daf1cf068b7ed6f80c9bff91236be64624d5ac6.png`,
          }))
        }
      }
    },
  },
  {
    url: '/activity/tabQuery', //请求地址
    response: () => {
      return {
        "ok": true,
        "code": 200,
        "msg": 'nodano',
        "timestamp": +new Date(),
        "data": {
          "tabList": [
            {
              "id": 1,
              "name": "财神红包雨星",
            },
            {
              "id": 2,
              "name": "tab1",
            },
            {
              "id": 3,
              "name": "tab2",
            },
            {
              "id": 4,
              "name": "tab3",
            },
            {
              "id": 5,
              "name": "tab4",
            }
          ]
        }
      }
    }
  },
  {
    url: '/activity/prizeRecords', //请求地址
    response: () => {
      return {
        "ok": true,
        "code": 200,
        "msg": 'nodano',
        "timestamp": +new Date(),
        "data": {
          "prizeRecords": new Array(20).fill(0).map((item, index) => ({
            "id": index + 1,
            "prizeName": `奖品名称${index + 1}`,
            "prizeImage": index == 0 ? `https://yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png` : `https://yun.duiba.com.cn/spark/assets/f77861647e7b55e9c95e9c49d891a21526157a76.jpg`,
            "prizeType": 1,
          }))
        }
      }
    }
  }
]