import React, { Component } from 'react';
import './homePage.less';
import { _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import Toast from '../../components/toast';
import store, { skinId } from '../../store';
import { PAGE_MAP } from '../../utils/constants';
import { observer } from 'mobx-react';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import modalStore from '../../store/modal';
@observer
class HomePage extends Component {
  constructor(props) {
    super(props);

    this.state = {
      curTab: 1,
    }
  }

  componentDidMount() {
    sensorMdExpouse("xcxPage", { pageName: `首页` })
    store.getIndexInfo();
    // modalStore.pushPop("WanLiuDialog")
  }

  beginBtnFun() {
    sensorMdClick("xcxClick", { pageName: `首页`, buttonName: '开始测试' })
    const flag = store.checkActivityStatus();
    if (!flag) return;
    store.joinActivity();
  }
  render() {
    const { curTab } = this.state;
    const { bg_type1, bg_type2, title, tab1, tab2, arrow_left, btn_prize, mainbtn, btn_future, mainbtn_popover, btn_rule, btn_share } = skinStore.homePage;
    return (
      <div className="com_Container">
        <div className="homePage">
          <div className="bg" style={{ 'backgroundImage': `url(${curTab === 1 ? bg_type1 : bg_type2})` }}></div>
          <div className="title" style={{ 'backgroundImage': `url(${title})` }}></div>
          {/* 规则 */}
          <div className="btn_rule" style={{ 'backgroundImage': `url(${btn_rule})` }}></div>
          {/* 分享 */}
          <div className="btn_share" style={{ 'backgroundImage': `url(${btn_share})` }}></div>
          {/* tab-活动展区 */}
          {curTab === 1 && <div className="tab1" onClick={() => this.setState({ curTab: 2 })} style={{ 'backgroundImage': `url(${tab1})` }}></div>}
          {/* tab-荣耀展区 */}
          {curTab === 2 && <div className="tab2" onClick={() => this.setState({ curTab: 1 })} style={{ 'backgroundImage': `url(${tab2})` }}></div>}
          {/* 勋章列表 */}
          <div className="medal_list_box">
            <div className="medal_list line1">
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal1.c022287fcb0174d828077cb5cf9b9b299d128a6b.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal2.341cc76fa221193683be4944f19dd63e1e5eee70.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal3.cd7c88c280902662cf3634b06ad0365ff7d75628.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png" alt="" />
              </div>
            </div>
            <div className="medal_list line2">
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal1.c022287fcb0174d828077cb5cf9b9b299d128a6b.png" alt="" />
              </div>
              <div className="medal_item grey">
                <img src="//yun.duiba.com.cn/polaris/medal2.341cc76fa221193683be4944f19dd63e1e5eee70.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal3.cd7c88c280902662cf3634b06ad0365ff7d75628.png" alt="" />
              </div>
              <div className="medal_item">
                <img src="//yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png" alt="" />
              </div>
            </div>
          </div>
          {/* 左滑引导 */}
          <div className="left_guide">
            <div className="arrow_left" style={{ 'backgroundImage': `url(${arrow_left})` }}></div>
            <div className="left_guide_text">左滑查看更多</div>
          </div>
          {/* 时光宝箱 */}
          <div className="btn_prize" style={{ 'backgroundImage': `url(${btn_prize})` }}></div>
          {/* 未来展品 */}
          <div className="btn_future" style={{ 'backgroundImage': `url(${btn_future})` }}></div>
          {/* 主按钮 */}
          <div className="mainbtn_box">
            <div className="mainbtn" style={{ 'backgroundImage': `url(${mainbtn})` }}></div>
            <div className="current_bb">当前持有：XX保贝值</div>
            <div className="mainbtn_popover" style={{ 'backgroundImage': `url(${mainbtn_popover})` }}>点亮勋章得XX保贝值</div>
          </div>
        </div>
      </div>
    );
  }
}

export default HomePage;
