import axios from 'axios'

// import { toast } from 'react-toastify';

// import { toast } from 'react-hot-toast';
import { errMessageMap } from '../utils/constants';
import { randomStr } from '../utils/utils';

import CryptoJS from 'crypto-js'

import Toast from '../components/toast';

// import { createHashHistory } from "history";

// const history = createHashHistory();


const service = axios.create({
  baseURL: import.meta.env.MODE != 'dev' ? '/dbcpic-nj-api/app' : '', // mockjs 模拟数据这里必须为空,否则请求报404 
  // baseURL: '/api', // mockjs 模拟数据这里必须为空,否则请求报404 
  method: 'post',
  timeout: 20000
})

let notShowMessage = false;

service.interceptors.request.use(config => {

  // console.log("config==>", typeof config.data, config.data)

  // 请求加签名
  // let timestamp = new Date().getTime();
  // let nonceStr = randomStr(20);
  // let app_secret = 'duiba123123';
  // let sign = null

  // if(config.url.indexOf("test/autoLogin") == -1 ) {
  //   if(config.data) {
  //     sign = CryptoJS.MD5(`${app_secret}${JSON.stringify(config.data)}${nonceStr}${timestamp}`).toString();
  //     config.data = {
  //       data: JSON.stringify({
  //         ...config.data,
  //       }),
  //       timestamp,
  //       nonceStr,
  //       sign
  //     }
      
  //   } else {
      
  //     sign = CryptoJS.MD5(`${app_secret}${nonceStr}${timestamp}`).toString();
  //     config.data = {
  //       timestamp,
  //       nonceStr,
  //       sign
  //     }
  //   }
  // }
  

  const isPostType = config.postType === 'formData'
  notShowMessage = config?.notShowMessage;

  config.headers['Content-Type'] = isPostType ? 'application/x-www-form-urlencoded' : 'application/json'
  if (config.method === 'get' && config.data) {
    let url = config.url + '?';
    for (const propName of Object.keys(config.data)) {
      const value = config.data[propName];
      var part = encodeURIComponent(propName) + "=";
      if (value !== null && typeof (value) !== "undefined") {
        if (typeof value === 'object') {
          for (const key of Object.keys(value)) {
            if (value[key] !== null && typeof (value[key]) !== 'undefined') {
              let params = propName + '[' + key + ']';
              let subPart = encodeURIComponent(params) + '=';
              url += subPart + encodeURIComponent(value[key]) + '&';
            }
          }
        } else {
          url += part + encodeURIComponent(value) + "&";
        }
      }
    }

    // url = url.slice(0, -1);
    // if(config.url.indexOf("api.map") == -1) {
    //   url += `sign=${sign}`
    // }

    config.data = {};
   
    config.url = url;
  }
  // console.error("看看生成的", config, config.data);
  return config
}, error => {
  // message.error('请求失败')
  Promise.reject(error)
})

// 响应拦截器 TODO 接口成功的状态情况
service.interceptors.response.use(data => {
  // console.warn("不是报错了吗")
  // console.warn("跳转了吗", data.data.code, data)
  // 所有请求完成后都要执行的操作
  if (!data.data.ok) {


    // if(data.data.code == '100018') {
    //   history.replace({ pathname: '/errorPage' })
    //   return data.data;
    // }

    // if(data.data.code == '100002') {
    //   history.replace({ pathname: '/' })
    //   return data.data;
    // }

    // if(data.data.code == '100020') {
    //   history.replace({ pathname: '/notePage' })
    //   return data.data;
    // }

    console.error("data.code", data.data.code, errMessageMap[data.data.code], notShowMessage)
    if (!notShowMessage) {
      if(errMessageMap[data.data.code]) {
        Toast(errMessageMap[data.data.code])
      } else {
        Toast(data.data.msg || '网络异常，请稍后再试哦～')
      }
    }

    return data.data;
  }

  return data.data
}, error => {
  let {
    // errorMessage
    msg
  } = error
  // if (!notShowMessage) {
    Toast(msg || '网络异常，请稍后再试哦～')
  // }

  return Promise.reject(error)
})

export default service