
export function diffTime(beforeDate, systemDate) {
  let _beforeDate = beforeDate

  if (!_beforeDate) return "-";
  _beforeDate = new Date(
    typeof beforeDate === "string" && isNaN(beforeDate) ?
    beforeDate.replace(/-/g, "/") :
    Number(beforeDate)
  );

  const diff = new Date().getTime() - new Date(_beforeDate).getTime();

  // 计算天数
  const day = Math.floor(diff / 1000 / 60 / 60 / 24);

  return day;
}

export function strLen(str, num) {
  if(!str) return '';
  return str > num ? str.slice(0, num) + '...' : str;
}

export function getUrlParam(name) {
  var search = window.location.search;
  var matched = search
    .slice(1)
    .match(new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i'));
  return search.length ? matched && matched[2] : null;
}

/**
* 删除url中的参数
* @param {*} url
* @param {*} arg
*/
export function delUrlParam(url, paramKey) {
 const _url = new URL(url)
 const search = new URLSearchParams(_url.search)
 search.delete(paramKey)
 _url.search = search.toString();
 return _url.href;
}

/** 判断云闪付环境*/
export function isYunApp() {
  let agent = navigator.userAgent.toLowerCase(); 
  // let isInsideWallet = (((new RegExp(/(com.unionpay.chsp)/).test(agent)) || (new RegExp(/(com.unionpay.mobilepay)/).test(agent))) && agent.indexOf('UnionPaySDK') == -1);
  let isInsideWallet = agent.indexOf('unionpaysdk') == -1;
  // console.log('isInsideWallet',isInsideWallet)
  return isInsideWallet;
}

/**
* 日期格式化
* @param date    接收可以被new Date()方法转换的内容
* @param format  字符串，需要的格式例如：'yyyy/MM/dd hh:mm:ss'
* @returns {String}
*/
export const dateFormatter = (date, format = "yyyy/MM/dd") => {
 if (!date) return "-";
 let _date = date
 let _format = format
 _date = new Date(
   typeof date === "string" && isNaN(date)
     ? date.replace(/-/g, "/")
     : Number(date)
 );
 const o = {
   "M+": _date.getMonth() + 1,
   "d+": _date.getDate(),
   "h+": _date.getHours(),
   "m+": _date.getMinutes(),
   "s+": _date.getSeconds(),
   "q+": Math.floor((_date.getMonth() + 3) / 3),
   S: _date.getMilliseconds(),
 };
 if (/(y+)/.test(_format)) {
  _format = format.replace(
     RegExp.$1,
     (_date.getFullYear() + "").substr(4 - RegExp.$1.length)
   );
 }
 for (const k in o) {
   if (new RegExp("(" + k + ")").test(_format)) {
    _format = _format.replace(
       RegExp.$1,
       RegExp.$1.length === 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length)
     );
   }
 }
 return _format;
};

// 设置导航栏
export const editTitle = (title = '') => {
  upsdk.pluginReady(function () {
    upsdk.setNavigationBarTitle({
      title: title,
    });
    // 前端API调用      
    upsdk.setTitleStyle({
      // 可选，导航栏(含状态栏)背景色及透明度。16进制，前2位(8F)透明度，后六位(FFFFFF)颜色，仅对当前页有效，其余页还是申请配置的导航默认颜色
      navBackgroundColor: '0xFFff585A',
      appletStyle: 'white', //可选，black-黑色主题，white-白色主题
      backBtnVisible: '0', // 可选，左侧返回按钮是否显示。'0'不显示，'1'显示，不传或空则默认显示
      appletTitleBarVisible: '1', // 可选，标题栏是否显示。'0'不显示，'1'显示，默认显示
      appletTitleGradientOrient: 'top', // 可选，渐变色方向，支持top、bottom、left、right
      appletTitleGradientStartColor: '0xFFff585A', //渐变起始颜色
      appletTitleGradientEndColor: '0xFFff585A' //渐变结束颜色
    });
  
  });
}

// Mozilla/5.0 (Linux; Android 10; PBCT10 Build/QKQ1.191224.003; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/77.0.3865.92 Mobile Safari/537.36(com.unionpay.mobilepay) (cordova 7.0.0) (updebug 2) (clientVersion 480) (version 905)(UnionPay/1.0 CloudPay)(language zh_CN)(upHtml)(UnionPaySDK 49992999)(BankVersion 278)


// rn跳转
export const rnJump = (dest, params = {}) => {
  console.error("params", params)
  upsdk.pluginReady(function(){ 
    upsdk.openRNPage({ 
      dest, //具体参数
      ...params,
      isFinished: "0", // 默认0，在当前窗口打开， 1 关闭当前webview(我用这个之后直接白屏) 
    })
  })
}

//小程序跳转
export const xcxJump = (appId, otherParam = {}) =>{
  console.error("otherParam", otherParam)
  upsdk.pluginReady(function () {
    upsdk.openApplet({
      appId: appId, // 加密的小程序应用id
      param: "", // 可选，拼在小程序 url 后的查询参数 
      ...otherParam,
      // gId=1表示商品id为1
      fail: function (code) {
        // code=101表示appId为空,code=102表示找不到该应用
        // console.log('open app：' + code);
      }
    })
  })
}

//云网跳转
export const ywJump = (appId,encryptId)=>{
  upsdk.openAppInfoByIdExt({
    appId:appId, //  非加密 和加密id择一必传
    encryptId:encryptId, //加密id 和非加密id择一必传
    type:"", //支持rn、native、html、applet，非必传，建议传
    perm:"", // 应用打开条件（同应用信息中perm）， 非必传，建议传
    extraData:"", //JsonString 额外传递参数，非必传
    isFinish:"", // 打开应用后，是否关闭当前界面；’0’:不关闭，’1’:关闭，默认0。非必传
    showLoading:"", //打开应用时是否显示loading，’0’:不展示，’1’:展示，默认1。非必传
    scenarioId:"", // 场景号,仅打开小程序生效。非必传
  });
}

// 是否是ios
export const isIos = () => {
  
  const _isIos = navigator.userAgent.match(/iphone|ipod|ipad/gi);

  return _isIos
}