import React, { useState } from 'react'
import './authPage.less'
import { useEffect } from 'react'
import { loginApi } from '../../api/api'
import { getUrlParam } from '../../utils'

const AuthPage = () => {
  const [loading, setLoading] = useState(false)

  useEffect(() => {
    console.log('authPage')
    doLogin()
  }, [])

  const doLogin = async () => {
    const fullUrl = window.location.href;
    let url = fullUrl.replace('auth.html', 'index.html');

    const res = await loginApi({
      token: getUrlParam("token"),
      src: "d8",
      redirectUrl: encodeURIComponent(encodeURIComponent(url)),
    });
    if (res.ok) {
      const { loginFlag, authBaseFlag, interestCollectionFlag, autoLoginUrl, token } = res.data || {};
      // 授权三合一（登录、授权、兴趣收集合并
      if (!loginFlag || !authBaseFlag || !interestCollectionFlag) {
        const link = `/packageAgent/pages/loading/loading?gwAuthToken=P_PT_PHONE_25Adolescentvision&token=${token}&channel=${CFG.channel}`
        console.info("官微小程序", link);
        wx?.miniProgram?.navigateTo({ url: link });
      } else {
        location.href = autoLoginUrl;
      }
    }
  }

  return (
    <div className="auth-container">

    </div>
  )
}

export default AuthPage 