import React, { Component } from 'react';
import './homePage.less';
import { _asyncThrottle, _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import store from '../../store';
import { MEDAL_TYPE, PAGE_MAP } from '../../utils/constants';
import { observer } from 'mobx-react';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import modalStore from '../../store/modal';
import { SvgaPlayer } from '../../components/SvgaPlayer';
@observer
class HomePage extends Component {
  constructor(props) {
    super(props);

    this.state = {
      curTab: MEDAL_TYPE.ACTIVITY,
    }
  }

  async componentDidMount() {
    sensorMdExpouse("activityPage", { pageName: `年鉴活动首页` })
    await store.getIndexInfo();
    await store.initSensorsMd();
  }

  // 保贝值抽奖
  drawHandle = _asyncThrottle(() => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: '保贝值抽奖' })
    const flag = store.checkActivityStatus();
    if (!flag) return;
    store.jumpDraw()
  })

  // 规则
  ruleHandle = _asyncThrottle(() => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: '规则' })
    modalStore.pushPop("RulePop")
  })

  // 时光宝箱
  prizeHandle = _asyncThrottle(() => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: '时光宝藏' })
    const flag = store.checkActivityStatus(true, false);
    if (!flag) return;
    store.changePage(PAGE_MAP.PRIZE_PAGE)
  })

  // 未来展品
  futureHandle = _asyncThrottle(() => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: '未来展品' })
    const flag = store.checkActivityStatus();
    if (!flag) return;
    store.changePage(PAGE_MAP.FUTURE_PAGE)
  })
  // 分享
  shareHandle = _asyncThrottle(() => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: '分享' })
    modalStore.pushPop("PosterPop")
  })

  // 切换tab
  tabHandle = (tab) => {
    this.setState({ curTab: tab })
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: tab === MEDAL_TYPE.ACTIVITY ? '活动展区' : '荣誉展区' })
  }

  // 勋章点击
  medalHandle = (item) => {
    sensorMdClick("activityClick", { pageName: `年鉴活动首页`, buttonName: item.name })
    const { boolGet, endTime, medalType } = item;
    // 勋章活动时间已过 此弹窗只在活动展区逻辑下会出现
    if (medalType === MEDAL_TYPE.ACTIVITY && endTime < +new Date()) {
      modalStore.pushPop("LightEndPop", item)
    }
    // 勋章已点亮
    else if (boolGet) {
      modalStore.pushPop("LightedPop", item)
    }
    // 勋章未点亮
    else {
      modalStore.pushPop("LightGreyPop", item)
    }
  }

  render() {
    const { bg_type1, bg_type2, title, tab1, tab2, arrow_left, btn_prize, mainbtn, mainbtn_bg, btn_future, mainbtn_popover, btn_rule, btn_share } = skinStore.homePage;
    const { home, huadong, box, saoguang } = skinStore.svga;

    const { curTab } = this.state;
    const { babyCredits } = store.indexInfo?.activityBaseInfo || {};
    const medalInfoList = store.indexInfo?.medalInfoList?.filter(item => item.medalType === curTab) || [];
    // 第一行 奇数索引的勋章
    const medalList1 = medalInfoList.filter((_, index) => index % 2 === 0);
    // 第二行 偶数索引的勋章
    const medalList2 = medalInfoList.filter((_, index) => index % 2 === 1);

    return (
      <div className="com_Container">
        <div className="homePage">
          <div className="bg" style={{ 'backgroundImage': `url(${curTab === MEDAL_TYPE.ACTIVITY ? bg_type1 : bg_type2})` }}></div>
          {/* <div className="title" style={{ 'backgroundImage': `url(${title})` }}></div> */}
          <SvgaPlayer className="home_svga" src={home} />
          {/* 规则 */}
          <div className="btn_rule" onClick={this.ruleHandle} style={{ 'backgroundImage': `url(${btn_rule})` }}></div>
          {/* 分享 */}
          <div className="btn_share" onClick={this.shareHandle} style={{ 'backgroundImage': `url(${btn_share})` }}></div>
          {/* tab-活动展区 */}
          {curTab === MEDAL_TYPE.ACTIVITY && <div className="tab1" style={{ 'backgroundImage': `url(${tab1})` }}></div>}
          {/* tab-荣耀展区 */}
          {curTab === MEDAL_TYPE.HONOR && <div className="tab2" style={{ 'backgroundImage': `url(${tab2})` }}></div>}
          <div className="tab1_click_area1" onClick={() => this.tabHandle(MEDAL_TYPE.ACTIVITY)}></div>
          <div className="tab1_click_area2" onClick={() => this.tabHandle(MEDAL_TYPE.HONOR)}></div>
          {/* 勋章列表 */}
          <div className="medal_list_box">
            <div className="medal_list line1">
              {medalList1.map((item, index) => (
                <div className={`medal_item ${item.boolGet ? '' : 'grey'}`} key={"line1_" + index} onClick={() => this.medalHandle(item)}>
                  <img src={item.icon} alt="" />
                  {/* TODO 动效确认 */}
                  {/* <SvgaPlayer className="saoguang" src={saoguang} /> */}
                </div>
              ))}
            </div>
            <div className="medal_list line2">
              {medalList2.map((item, index) => (
                <div className={`medal_item ${item.boolGet ? '' : 'grey'}`} key={"line2_" + index} onClick={() => this.medalHandle(item)}>
                  <img src={item.icon} alt="" />
                  {/* <SvgaPlayer className="saoguang" src={saoguang} /> */}
                </div>
              ))}
            </div>
          </div>
          {/* 左滑引导 */}
          <div className="left_guide">
            {/* <div className="arrow_left" style={{ 'backgroundImage': `url(${arrow_left})` }}></div>
            <div className="left_guide_text">左滑查看更多</div> */}
            <SvgaPlayer className="huadong" src={huadong} />
          </div>
          {/* 时光宝箱 */}
          <div className="btn_prize" onClick={this.prizeHandle} style={{ 'backgroundImage': `url(${btn_prize})` }}></div>
          {/* 未来展品 */}
          <div className="btn_future" onClick={this.futureHandle} style={{ 'backgroundImage': `url(${btn_future})` }}></div>
          {/* 主按钮 */}
          <div className="mainbtn_box" onClick={this.drawHandle}>
            <div className="mainbtn_bg" style={{ 'backgroundImage': `url(${mainbtn_bg})` }}></div>
            <SvgaPlayer className="box" src={box} />
            <div className="mainbtn" style={{ 'backgroundImage': `url(${mainbtn})` }}></div>
            <div className="current_bb">当前持有：{babyCredits}保贝值</div>
            <div className="mainbtn_popover" style={{ 'backgroundImage': `url(${mainbtn_popover})` }}>点亮勋章得50保贝值</div>
          </div>
        </div>
      </div>
    );
  }
}

export default HomePage;
