import React, { Component } from 'react';
import './lightEndPop.less';
import { observer } from 'mobx-react';
import modalStore from '../../store/modal';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import skinStore from '../../store/newSkin';
@observer
class LightEndPop extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    sensorMdExpouse("xcxPopupExpouse", { pageName: `点亮勋章弹窗` })
  }

  handleClose() {
    sensorMdClick("xcxPopupClick", { pageName: `点亮勋章弹窗`, buttonName: '继续评估' })
    modalStore.closePop("LightEndPop")
  }
  render() {
    const { lightEndPop, common } = skinStore
    const { bg, know_btn } = lightEndPop
    const { close } = common

    return <div className="lightEndPop modal_center">
      <span className="bg" style={{ backgroundImage: `url(${bg})` }} ></span>
      <div className="title">该展品活动已经结束啦</div>
      <div className="desc">快去看看其他展品进行点亮吧!</div>
      <span className="close" onClick={this.handleClose} style={{ backgroundImage: `url(${close})` }} />
      <span className="know_btn" onClick={this.handleClose} style={{ backgroundImage: `url(${know_btn})` }} />
    </div>
  }
}
export default LightEndPop;