import React, { forwardRef, useState, useRef, useImperativeHandle, useEffect } from 'react';
import { loadImage } from '../toast/utils';

function createCommonjsModule(fn, basedir, module) {
	return module = {
		path: basedir,
		exports: {},
		require: function (path, base) {
			return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
		}
	}, fn(module, module.exports), module.exports;
}

function commonjsRequire () {
	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
}

var svga_lite_min = createCommonjsModule(function (module, exports) {
/*!
 * svga.lite
 * 
 * Version: 1.6.0
 * Document: https://github.com/svga/SVGAPlayer-Web-Lite
 * (c) 2019 YY.SVGA
 * Released under the MIT License.
 */
!function(e,t){module.exports=t();}(window,function(){return function(e){var t={};function r(n){if(t[n])return t[n].exports;var o=t[n]={i:n,l:!1,exports:{}};return e[n].call(o.exports,o,o.exports,r),o.l=!0,o.exports}return r.m=e,r.c=t,r.d=function(e,t,n){r.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n});},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0});},r.t=function(e,t){if(1&t&&(e=r(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(r.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)r.d(n,o,function(t){return e[t]}.bind(null,o));return n},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=1)}([function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n=function(e,t,r){this._d=e,this._transform=t,this._styles=r;};t.default=n;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n=r(2),o=r(3),i=r(4),s={Downloader:n.default,Parser:o.default,Player:i.default};t.default=s;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n=function(){function e(){this.request=null;}return e.prototype.get=function(e){var t=this;if(!e)throw new Error("download link undefined");return new Promise(function(r,n){var o=new XMLHttpRequest;o.open("GET",e,!0),o.responseType="arraybuffer",o.onloadend=function(){!o.response||200!==o.status&&304!==o.status?n(o):r(o.response);},o.onerror=function(){return n(o.response)},o.send(),t.request=o;})},e.prototype.cancel=function(){this.request&&this.request.abort();},e.prototype.destroy=function(){this.request&&this.request.abort();},e}();t.default=n;},function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0});var WORKER="!function(t){var e={};function r(i){if(e[i])return e[i].exports;var s=e[i]={i:i,l:!1,exports:{}};return t[i].call(s.exports,s,s.exports,r),s.l=!0,s.exports}r.m=t,r.c=e,r.d=function(t,e,i){r.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:i})},r.r=function(t){\"undefined\"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:\"Module\"}),Object.defineProperty(t,\"__esModule\",{value:!0})},r.t=function(t,e){if(1&e&&(t=r(t)),8&e)return t;if(4&e&&\"object\"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(r.r(i),Object.defineProperty(i,\"default\",{enumerable:!0,value:t}),2&e&&\"string\"!=typeof t)for(var s in t)r.d(i,s,function(e){return t[e]}.bind(null,s));return i},r.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return r.d(e,\"a\",e),e},r.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},r.p=\"\",r(r.s=8)}([function(t,e,r){\"use strict\";var i=t.exports=r(6);i.codegen=r(16),i.toArray=function(t){if(t){for(var e=Object.keys(t),r=new Array(e.length),i=0;i<e.length;)r[i]=t[e[i++]];return r}return[]};var s=/\\\\/g,n=/\"/g;i.isReserved=function(t){return/^(?:do|if|in|for|let|new|try|var|case|else|enum|eval|false|null|this|true|void|with|break|catch|class|const|super|throw|while|yield|delete|export|import|public|return|static|switch|typeof|default|extends|finally|package|private|continue|debugger|function|arguments|interface|protected|implements|instanceof)$/.test(t)},i.safeProp=function(t){return!/^[$\\w_]+$/.test(t)||i.isReserved(t)?'[\"'+t.replace(s,\"\\\\\\\\\").replace(n,'\\\\\"')+'\"]':\".\"+t}},function(t,e,r){\"use strict\";t.exports=h;var i=r(2);((h.prototype=Object.create(i.prototype)).constructor=h).className=\"Field\";var s,n=r(3),o=r(5),a=r(0),f=/^required|optional|repeated$/;function h(t,e,r,s,n,h,l){if(a.isObject(s)?(l=n,h=s,s=n=void 0):a.isObject(n)&&(l=h,h=n,n=void 0),i.call(this,t,h),!a.isInteger(e)||e<0)throw TypeError(\"id must be a non-negative integer\");if(!a.isString(r))throw TypeError(\"type must be a string\");if(void 0!==s&&!f.test(s=s.toString().toLowerCase()))throw TypeError(\"rule must be a string rule\");if(void 0!==n&&!a.isString(n))throw TypeError(\"extend must be a string\");this.rule=s&&\"optional\"!==s?s:void 0,this.type=r,this.id=e,this.extend=n||void 0,this.required=\"required\"===s,this.optional=!this.required,this.repeated=\"repeated\"===s,this.map=!1,this.message=null,this.partOf=null,this.typeDefault=null,this.defaultValue=null,this.long=!!a.Long&&void 0!==o.long[r],this.bytes=\"bytes\"===r,this.resolvedType=null,this.extensionField=null,this.declaringField=null,this._packed=null,this.comment=l}h.fromJSON=function(t,e){return new h(t,e.id,e.type,e.rule,e.extend,e.options,e.comment)},h.prototype.setOption=function(t,e,r){return\"packed\"===t&&(this._packed=null),i.prototype.setOption.call(this,t,e,r)},h.prototype.resolve=function(){if(this.resolved)return this;if(void 0===(this.typeDefault=o.defaults[this.type])&&(this.resolvedType=(this.declaringField?this.declaringField.parent:this.parent).lookupTypeOrEnum(this.type),this.resolvedType instanceof s?this.typeDefault=null:this.typeDefault=this.resolvedType.values[Object.keys(this.resolvedType.values)[0]]),this.options&&null!=this.options.default&&(this.typeDefault=this.options.default,this.resolvedType instanceof n&&\"string\"==typeof this.typeDefault&&(this.typeDefault=this.resolvedType.values[this.typeDefault])),this.options&&(!0!==this.options.packed&&(void 0===this.options.packed||!this.resolvedType||this.resolvedType instanceof n)||delete this.options.packed,Object.keys(this.options).length||(this.options=void 0)),this.long)this.typeDefault=a.Long.fromNumber(this.typeDefault,\"u\"===this.type.charAt(0)),Object.freeze&&Object.freeze(this.typeDefault);else if(this.bytes&&\"string\"==typeof this.typeDefault){var t;a.base64.test(this.typeDefault)?a.base64.decode(this.typeDefault,t=a.newBuffer(a.base64.length(this.typeDefault)),0):a.utf8.write(this.typeDefault,t=a.newBuffer(a.utf8.length(this.typeDefault)),0),this.typeDefault=t}return this.map?this.defaultValue=a.emptyObject:this.repeated?this.defaultValue=a.emptyArray:this.defaultValue=this.typeDefault,this.parent instanceof s&&(this.parent.ctor.prototype[this.name]=this.defaultValue),i.prototype.resolve.call(this)},h._configure=function(t){s=t}},function(t,e,r){\"use strict\";var i;function s(t,e){this.options=e,this.name=t,this.parent=null,this.resolved=!1,this.comment=null,this.filename=null}t.exports=s,s.className=\"ReflectionObject\",s.prototype.onAdd=function(t){this.parent&&this.parent!==t&&this.parent.remove(this),this.parent=t,this.resolved=!1;var e=t.root;e instanceof i&&e._handleAdd(this)},s.prototype.resolve=function(){return this.resolved?this:(this.root instanceof i&&(this.resolved=!0),this)},s.prototype.getOption=function(t){if(this.options)return this.options[t]},s._configure=function(t){i=t}},function(t,e,r){\"use strict\";t.exports=s;var i=r(2);function s(t,e,r,s,n){if(i.call(this,t,r),e&&\"object\"!=typeof e)throw TypeError(\"values must be an object\");if(this.valuesById={},this.values=Object.create(this.valuesById),this.comment=s,this.comments=n||{},this.reserved=void 0,e)for(var o=Object.keys(e),a=0;a<o.length;++a)\"number\"==typeof e[o[a]]&&(this.valuesById[this.values[o[a]]=e[o[a]]]=o[a])}((s.prototype=Object.create(i.prototype)).constructor=s).className=\"Enum\",s.fromJSON=function(t,e){var r=new s(t,e.values,e.options,e.comment,e.comments);return r.reserved=e.reserved,r}},function(t,e,r){\"use strict\";t.exports=h;var i=r(2);((h.prototype=Object.create(i.prototype)).constructor=h).className=\"Namespace\";var s,n,o,a=r(1),f=r(0);function h(t,e){i.call(this,t,e),this.nested=void 0,this._nestedArray=null}h.fromJSON=function(t,e){return new h(t,e.options).addJSON(e.nested)},h.isReservedId=function(t,e){if(t)for(var r=0;r<t.length;++r)if(\"string\"!=typeof t[r]&&t[r][0]<=e&&t[r][1]>=e)return!0;return!1},h.isReservedName=function(t,e){if(t)for(var r=0;r<t.length;++r)if(t[r]===e)return!0;return!1},Object.defineProperty(h.prototype,\"nestedArray\",{get:function(){return this._nestedArray||(this._nestedArray=f.toArray(this.nested))}}),h.prototype.addJSON=function(t){if(t)for(var e,r=Object.keys(t),i=0;i<r.length;++i)e=t[r[i]],this.add((void 0!==e.fields?s.fromJSON:void 0!==e.values?o.fromJSON:void 0!==e.methods?n.fromJSON:void 0!==e.id?a.fromJSON:h.fromJSON)(r[i],e));return this},h.prototype.get=function(t){return this.nested&&this.nested[t]||null},h.prototype.add=function(t){if(!(t instanceof a&&void 0!==t.extend||t instanceof s||t instanceof o||t instanceof n||t instanceof h))throw TypeError(\"object must be a valid nested object\");if(this.nested){var e=this.get(t.name);if(e){if(!(e instanceof h&&t instanceof h)||e instanceof s||e instanceof n)throw Error(\"duplicate name '\"+t.name+\"' in \"+this);for(var r=e.nestedArray,i=0;i<r.length;++i)t.add(r[i]);this.remove(e),this.nested||(this.nested={}),t.setOptions(e.options,!0)}}else this.nested={};return this.nested[t.name]=t,t.onAdd(this),(f=this)._nestedArray=null,f;var f},h.prototype.lookup=function(t,e,r){if(\"boolean\"==typeof e?(r=e,e=void 0):e&&!Array.isArray(e)&&(e=[e]),f.isString(t)&&t.length){if(\".\"===t)return this.root;t=t.split(\".\")}else if(!t.length)return this;if(\"\"===t[0])return this.root.lookup(t.slice(1),e);var i=this.get(t[0]);if(i){if(1===t.length){if(!e||e.indexOf(i.constructor)>-1)return i}else if(i instanceof h&&(i=i.lookup(t.slice(1),e,!0)))return i}else for(var s=0;s<this.nestedArray.length;++s)if(this._nestedArray[s]instanceof h&&(i=this._nestedArray[s].lookup(t,e,!0)))return i;return null===this.parent||r?null:this.parent.lookup(t,e)},h.prototype.lookupType=function(t){var e=this.lookup(t,[s]);if(!e)throw Error(\"no such type: \"+t);return e},h.prototype.lookupTypeOrEnum=function(t){var e=this.lookup(t,[s,o]);if(!e)throw Error(\"no such Type or Enum '\"+t+\"' in \"+this);return e},h._configure=function(t,e,r){s=t,n=e,o=r}},function(t,e,r){\"use strict\";var i=e,s=r(0),n=[\"double\",\"float\",\"int32\",\"uint32\",\"sint32\",\"fixed32\",\"sfixed32\",\"int64\",\"uint64\",\"sint64\",\"fixed64\",\"sfixed64\",\"bool\",\"string\",\"bytes\"];function o(t,e){var r=0,i={};for(e|=0;r<t.length;)i[n[r+e]]=t[r++];return i}i.basic=o([1,5,0,0,0,5,5,0,0,0,1,1,0,2,2]),i.defaults=o([0,0,0,0,0,0,0,0,0,0,0,0,!1,\"\",s.emptyArray,null]),i.long=o([0,0,0,1,1],7),i.mapKey=o([0,0,0,5,5,0,0,0,1,1,0,2],2),i.packed=o([1,5,0,0,0,5,5,0,0,0,1,1,0])},function(t,e,r){\"use strict\";var i=e;i.float=r(14),i.utf8=r(15),i.emptyArray=Object.freeze?Object.freeze([]):[],i.emptyObject=Object.freeze?Object.freeze({}):{},i.isInteger=Number.isInteger||function(t){return\"number\"==typeof t&&isFinite(t)&&Math.floor(t)===t},i.isString=function(t){return\"string\"==typeof t||t instanceof String},i.isObject=function(t){return t&&\"object\"==typeof t},i.Array=\"undefined\"!=typeof Uint8Array?Uint8Array:Array,i._configure=function(){var t=i.Buffer;t?(i._Buffer_from=t.from!==Uint8Array.from&&t.from||function(e,r){return new t(e,r)},i._Buffer_allocUnsafe=t.allocUnsafe||function(e){return new t(e)}):i._Buffer_from=i._Buffer_allocUnsafe=null}},function(t,e,r){\"use strict\";t.exports=s;var i=r(4);function s(t,e){i.call(this,t,e),this.methods={},this._methodsArray=null}((s.prototype=Object.create(i.prototype)).constructor=s).className=\"Service\"},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0}),r(9);var i,s=r(10),n=r(23),o=r(24),a=r(25),f=r(26);self.document?((i=self.SVGAParserMockWorker={}).disableWorker=!0,i.postMessage=function(t){i.onmessageCallback&&i.onmessageCallback(t)}):i=self;var h=s.Root.fromJSON(n.default).lookupType(\"com.opensource.svga.MovieEntity\");i.onmessage=function(t){var e=new o.Zlib.Inflate(new Uint8Array(t.data)).decompress(),r=h.decode(e),s={};for(var n in r.images){var l=r.images[n],u=a.default(l);s[n]=btoa(u)}var p=new f.default(r,s);i.postMessage(p)}},function(t,e,r){\"use strict\";var i=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";!self.btoa&&(self.btoa=function(t){for(var e,r,s,n,o=\"\",a=0,f=(t=String(t)).length%3;a<t.length;){if((r=t.charCodeAt(a++))>255||(s=t.charCodeAt(a++))>255||(n=t.charCodeAt(a++))>255)throw new TypeError(\"Failed to execute 'btoa' on 'Window': The string to be encoded contains characters outside of the Latin1 range.\");o+=i.charAt((e=r<<16|s<<8|n)>>18&63)+i.charAt(e>>12&63)+i.charAt(e>>6&63)+i.charAt(63&e)}return f?o.slice(0,f-3)+\"===\".substring(f):o})},function(t,e,r){\"use strict\";t.exports=r(11)},function(t,e,r){\"use strict\";(t.exports=r(12)).build=\"full\"},function(t,e,r){\"use strict\";var i=t.exports=r(13);i.build=\"light\",i.ReflectionObject=r(2),i.Namespace=r(4),i.Root=r(17),i.Enum=r(3),i.Type=r(19),i.Field=r(1),i.Service=r(7),i.ReflectionObject._configure(i.Root),i.Namespace._configure(i.Type,i.Service,i.Enum),i.Root._configure(i.Type),i.Field._configure(i.Type)},function(t,e,r){\"use strict\";e.build=\"minimal\"},function(t,e,r){\"use strict\";function i(t){return\"undefined\"!=typeof Float32Array?function(){var e=new Float32Array([-0]),r=new Uint8Array(e.buffer),i=128===r[3];function s(t,i,s){e[0]=t,i[s]=r[0],i[s+1]=r[1],i[s+2]=r[2],i[s+3]=r[3]}function n(t,i,s){e[0]=t,i[s]=r[3],i[s+1]=r[2],i[s+2]=r[1],i[s+3]=r[0]}function o(t,i){return r[0]=t[i],r[1]=t[i+1],r[2]=t[i+2],r[3]=t[i+3],e[0]}function a(t,i){return r[3]=t[i],r[2]=t[i+1],r[1]=t[i+2],r[0]=t[i+3],e[0]}t.writeFloatLE=i?s:n,t.writeFloatBE=i?n:s,t.readFloatLE=i?o:a,t.readFloatBE=i?a:o}():function(){function e(t,e,r,i){var s=e<0?1:0;if(s&&(e=-e),0===e)t(1/e>0?0:2147483648,r,i);else if(isNaN(e))t(2143289344,r,i);else if(e>34028234663852886e22)t((s<<31|2139095040)>>>0,r,i);else if(e<11754943508222875e-54)t((s<<31|Math.round(e/1401298464324817e-60))>>>0,r,i);else{var n=Math.floor(Math.log(e)/Math.LN2);t((s<<31|n+127<<23|8388607&Math.round(e*Math.pow(2,-n)*8388608))>>>0,r,i)}}function r(t,e,r){var i=t(e,r),s=2*(i>>31)+1,n=i>>>23&255,o=8388607&i;return 255===n?o?NaN:s*(1/0):0===n?1401298464324817e-60*s*o:s*Math.pow(2,n-150)*(o+8388608)}t.writeFloatLE=e.bind(null,s),t.writeFloatBE=e.bind(null,n),t.readFloatLE=r.bind(null,o),t.readFloatBE=r.bind(null,a)}(),\"undefined\"!=typeof Float64Array?function(){var e=new Float64Array([-0]),r=new Uint8Array(e.buffer),i=128===r[7];function s(t,i,s){e[0]=t,i[s]=r[0],i[s+1]=r[1],i[s+2]=r[2],i[s+3]=r[3],i[s+4]=r[4],i[s+5]=r[5],i[s+6]=r[6],i[s+7]=r[7]}function n(t,i,s){e[0]=t,i[s]=r[7],i[s+1]=r[6],i[s+2]=r[5],i[s+3]=r[4],i[s+4]=r[3],i[s+5]=r[2],i[s+6]=r[1],i[s+7]=r[0]}function o(t,i){return r[0]=t[i],r[1]=t[i+1],r[2]=t[i+2],r[3]=t[i+3],r[4]=t[i+4],r[5]=t[i+5],r[6]=t[i+6],r[7]=t[i+7],e[0]}function a(t,i){return r[7]=t[i],r[6]=t[i+1],r[5]=t[i+2],r[4]=t[i+3],r[3]=t[i+4],r[2]=t[i+5],r[1]=t[i+6],r[0]=t[i+7],e[0]}t.writeDoubleLE=i?s:n,t.writeDoubleBE=i?n:s,t.readDoubleLE=i?o:a,t.readDoubleBE=i?a:o}():function(){function e(t,e,r,i,s,n){var o=i<0?1:0;if(o&&(i=-i),0===i)t(0,s,n+e),t(1/i>0?0:2147483648,s,n+r);else if(isNaN(i))t(0,s,n+e),t(2146959360,s,n+r);else if(i>17976931348623157e292)t(0,s,n+e),t((o<<31|2146435072)>>>0,s,n+r);else{var a;if(i<22250738585072014e-324)t((a=i/5e-324)>>>0,s,n+e),t((o<<31|a/4294967296)>>>0,s,n+r);else{var f=Math.floor(Math.log(i)/Math.LN2);1024===f&&(f=1023),t(4503599627370496*(a=i*Math.pow(2,-f))>>>0,s,n+e),t((o<<31|f+1023<<20|1048576*a&1048575)>>>0,s,n+r)}}}function r(t,e,r,i,s){var n=t(i,s+e),o=t(i,s+r),a=2*(o>>31)+1,f=o>>>20&2047,h=4294967296*(1048575&o)+n;return 2047===f?h?NaN:a*(1/0):0===f?5e-324*a*h:a*Math.pow(2,f-1075)*(h+4503599627370496)}t.writeDoubleLE=e.bind(null,s,0,4),t.writeDoubleBE=e.bind(null,n,4,0),t.readDoubleLE=r.bind(null,o,0,4),t.readDoubleBE=r.bind(null,a,4,0)}(),t}function s(t,e,r){e[r]=255&t,e[r+1]=t>>>8&255,e[r+2]=t>>>16&255,e[r+3]=t>>>24}function n(t,e,r){e[r]=t>>>24,e[r+1]=t>>>16&255,e[r+2]=t>>>8&255,e[r+3]=255&t}function o(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16|t[e+3]<<24)>>>0}function a(t,e){return(t[e]<<24|t[e+1]<<16|t[e+2]<<8|t[e+3])>>>0}t.exports=i(i)},function(t,e,r){\"use strict\";var i=e;i.length=function(t){for(var e=0,r=0,i=0;i<t.length;++i)(r=t.charCodeAt(i))<128?e+=1:r<2048?e+=2:55296==(64512&r)&&56320==(64512&t.charCodeAt(i+1))?(++i,e+=4):e+=3;return e},i.read=function(t,e,r){if(r-e<1)return\"\";for(var i,s=null,n=[],o=0;e<r;)(i=t[e++])<128?n[o++]=i:i>191&&i<224?n[o++]=(31&i)<<6|63&t[e++]:i>239&&i<365?(i=((7&i)<<18|(63&t[e++])<<12|(63&t[e++])<<6|63&t[e++])-65536,n[o++]=55296+(i>>10),n[o++]=56320+(1023&i)):n[o++]=(15&i)<<12|(63&t[e++])<<6|63&t[e++],o>8191&&((s||(s=[])).push(String.fromCharCode.apply(String,n)),o=0);return s?(o&&s.push(String.fromCharCode.apply(String,n.slice(0,o))),s.join(\"\")):String.fromCharCode.apply(String,n.slice(0,o))},i.write=function(t,e,r){for(var i,s,n=r,o=0;o<t.length;++o)(i=t.charCodeAt(o))<128?e[r++]=i:i<2048?(e[r++]=i>>6|192,e[r++]=63&i|128):55296==(64512&i)&&56320==(64512&(s=t.charCodeAt(o+1)))?(i=65536+((1023&i)<<10)+(1023&s),++o,e[r++]=i>>18|240,e[r++]=i>>12&63|128,e[r++]=i>>6&63|128,e[r++]=63&i|128):(e[r++]=i>>12|224,e[r++]=i>>6&63|128,e[r++]=63&i|128);return r-n}},function(t,e,r){\"use strict\";function i(t,e){\"string\"==typeof t&&(e=t,t=void 0);var r=[];function s(t){if(\"string\"!=typeof t){var e=n();if(i.verbose&&console.log(\"codegen: \"+e),e=\"return \"+e,t){for(var o=Object.keys(t),a=new Array(o.length+1),f=new Array(o.length),h=0;h<o.length;)a[h]=o[h],f[h]=t[o[h++]];return a[h]=e,Function.apply(null,a).apply(null,f)}return Function(e)()}for(var l=new Array(arguments.length-1),u=0;u<l.length;)l[u]=arguments[++u];if(u=0,t=t.replace(/%([%dfijs])/g,function(t,e){var r=l[u++];switch(e){case\"d\":case\"f\":return String(Number(r));case\"i\":return String(Math.floor(r));case\"j\":return JSON.stringify(r);case\"s\":return String(r)}return\"%\"}),u!==l.length)throw Error(\"parameter count mismatch\");return r.push(t),s}function n(i){return\"function \"+(i||e||\"\")+\"(\"+(t&&t.join(\",\")||\"\")+\"){\\n  \"+r.join(\"\\n  \")+\"\\n}\"}return s.toString=n,s}t.exports=i,i.verbose=!1},function(t,e,r){\"use strict\";t.exports=f;var i=r(4);((f.prototype=Object.create(i.prototype)).constructor=f).className=\"Root\";var s,n=r(1),o=r(3),a=r(18);function f(t){i.call(this,\"\",t),this.deferred=[],this.files=[]}f.fromJSON=function(t,e){return e||(e=new f),t.options&&e.setOptions(t.options),e.addJSON(t.nested)};var h=/^[A-Z]/;function l(t,e){var r=e.parent.lookup(e.extend);if(r){var i=new n(e.fullName,e.id,e.type,e.rule,void 0,e.options);return i.declaringField=e,e.extensionField=i,r.add(i),!0}return!1}f.prototype._handleAdd=function(t){if(t instanceof n)void 0===t.extend||t.extensionField||l(0,t)||this.deferred.push(t);else if(t instanceof o)h.test(t.name)&&(t.parent[t.name]=t.values);else if(!(t instanceof a)){if(t instanceof s)for(var e=0;e<this.deferred.length;)l(0,this.deferred[e])?this.deferred.splice(e,1):++e;for(var r=0;r<t.nestedArray.length;++r)this._handleAdd(t._nestedArray[r]);h.test(t.name)&&(t.parent[t.name]=t)}},f._configure=function(t,e,r){s=t,e,r}},function(t,e,r){\"use strict\";t.exports=o;var i=r(2);((o.prototype=Object.create(i.prototype)).constructor=o).className=\"OneOf\";var s=r(1),n=r(0);function o(t,e,r,s){if(Array.isArray(e)||(r=e,e=void 0),i.call(this,t,r),void 0!==e&&!Array.isArray(e))throw TypeError(\"fieldNames must be an Array\");this.oneof=e||[],this.fieldsArray=[],this.comment=s}function a(t){if(t.parent)for(var e=0;e<t.fieldsArray.length;++e)t.fieldsArray[e].parent||t.parent.add(t.fieldsArray[e])}o.fromJSON=function(t,e){return new o(t,e.oneof,e.options,e.comment)},o.prototype.toJSON=function(t){var e=!!t&&Boolean(t.keepComments);return n.toObject([\"options\",this.options,\"oneof\",this.oneof,\"comment\",e?this.comment:void 0])},o.prototype.add=function(t){if(!(t instanceof s))throw TypeError(\"field must be a Field\");return t.parent&&t.parent!==this.parent&&t.parent.remove(t),this.oneof.push(t.name),this.fieldsArray.push(t),t.partOf=this,a(this),this},o.prototype.remove=function(t){if(!(t instanceof s))throw TypeError(\"field must be a Field\");var e=this.fieldsArray.indexOf(t);if(e<0)throw Error(t+\" is not a member of \"+this);return this.fieldsArray.splice(e,1),(e=this.oneof.indexOf(t.name))>-1&&this.oneof.splice(e,1),t.partOf=null,this},o.prototype.onAdd=function(t){i.prototype.onAdd.call(this,t);for(var e=0;e<this.oneof.length;++e){var r=t.get(this.oneof[e]);r&&!r.partOf&&(r.partOf=this,this.fieldsArray.push(r))}a(this)},o.prototype.onRemove=function(t){for(var e,r=0;r<this.fieldsArray.length;++r)(e=this.fieldsArray[r]).parent&&e.parent.remove(e);i.prototype.onRemove.call(this,t)},o.d=function(){for(var t=new Array(arguments.length),e=0;e<arguments.length;)t[e]=arguments[e++];return function(e,r){n.decorateType(e.constructor).add(new o(r,t)),Object.defineProperty(e,r,{get:n.oneOfGetter(t),set:n.oneOfSetter(t)})}}},function(t,e,r){\"use strict\";t.exports=u;var i=r(4);((u.prototype=Object.create(i.prototype)).constructor=u).className=\"Type\";var s=r(3),n=r(1),o=r(20),a=r(7),f=r(21),h=r(0),l=r(22);function u(t,e){i.call(this,t,e),this.fields={},this.oneofs=void 0,this.extensions=void 0,this.reserved=void 0,this.group=void 0,this._fieldsById=null,this._fieldsArray=null,this._oneofsArray=null,this._ctor=null}Object.defineProperties(u.prototype,{fieldsById:{get:function(){if(this._fieldsById)return this._fieldsById;this._fieldsById={};for(var t=Object.keys(this.fields),e=0;e<t.length;++e){var r=this.fields[t[e]],i=r.id;if(this._fieldsById[i])throw Error(\"duplicate id \"+i+\" in \"+this);this._fieldsById[i]=r}return this._fieldsById}},fieldsArray:{get:function(){return this._fieldsArray||(this._fieldsArray=h.toArray(this.fields))}},oneofsArray:{get:function(){return this._oneofsArray||(this._oneofsArray=h.toArray(this.oneofs))}},ctor:{get:function(){return this._ctor||(this.ctor=u.generateConstructor(this)())},set:function(t){t.prototype;t.$type=t.prototype.$type=this,this._ctor=t;for(var e=0;e<this.fieldsArray.length;++e)this._fieldsArray[e].resolve();var r={};for(e=0;e<this.oneofsArray.length;++e)r[this._oneofsArray[e].resolve().name]={get:h.oneOfGetter(this._oneofsArray[e].oneof),set:h.oneOfSetter(this._oneofsArray[e].oneof)};e&&Object.defineProperties(t.prototype,r)}}}),u.generateConstructor=function(t){for(var e,r=h.codegen([\"p\"],t.name),i=0;i<t.fieldsArray.length;++i)(e=t._fieldsArray[i]).map?r(\"this%s={}\",h.safeProp(e.name)):e.repeated&&r(\"this%s=[]\",h.safeProp(e.name));return r(\"if(p)for(var ks=Object.keys(p),i=0;i<ks.length;++i)if(p[ks[i]]!=null)\")(\"this[ks[i]]=p[ks[i]]\")},u.fromJSON=function(t,e){var r=new u(t,e.options);r.extensions=e.extensions,r.reserved=e.reserved;for(var f=Object.keys(e.fields),h=0;h<f.length;++h)r.add((void 0!==e.fields[f[h]].keyType?o.fromJSON:n.fromJSON)(f[h],e.fields[f[h]]));if(e.nested)for(f=Object.keys(e.nested),h=0;h<f.length;++h){var l=e.nested[f[h]];r.add((void 0!==l.id?n.fromJSON:void 0!==l.fields?u.fromJSON:void 0!==l.values?s.fromJSON:void 0!==l.methods?a.fromJSON:i.fromJSON)(f[h],l))}return e.extensions&&e.extensions.length&&(r.extensions=e.extensions),e.reserved&&e.reserved.length&&(r.reserved=e.reserved),e.group&&(r.group=!0),e.comment&&(r.comment=e.comment),r},u.prototype.add=function(t){if(this.get(t.name))throw Error(\"duplicate name '\"+t.name+\"' in \"+this);if(t instanceof n&&void 0===t.extend){if(this._fieldsById?this._fieldsById[t.id]:this.fieldsById[t.id])throw Error(\"duplicate id \"+t.id+\" in \"+this);if(this.isReservedId(t.id))throw Error(\"id \"+t.id+\" is reserved in \"+this);if(this.isReservedName(t.name))throw Error(\"name '\"+t.name+\"' is reserved in \"+this);return t.parent&&t.parent.remove(t),this.fields[t.name]=t,t.message=this,t.onAdd(this),(e=this)._fieldsById=e._fieldsArray=e._oneofsArray=null,delete e.encode,delete e.decode,delete e.verify,e}var e;return i.prototype.add.call(this,t)},u.prototype.isReservedId=function(t){return i.isReservedId(this.reserved,t)},u.prototype.isReservedName=function(t){return i.isReservedName(this.reserved,t)},u.prototype.setup=function(){this.fullName;for(var t=[],e=0;e<this.fieldsArray.length;++e)t.push(this._fieldsArray[e].resolve().resolvedType);return this.decode=l(this)({Reader:f,types:t,util:h}),this},u.prototype.decode=function(t,e){return this.setup().decode(t,e)}},function(t,e,r){\"use strict\";t.exports=n;var i=r(1);((n.prototype=Object.create(i.prototype)).constructor=n).className=\"MapField\";r(5);var s=r(0);function n(t,e,r,n,o,a){if(i.call(this,t,e,n,void 0,void 0,o,a),!s.isString(r))throw TypeError(\"keyType must be a string\");this.keyType=r,this.resolvedKeyType=null,this.map=!0}n.fromJSON=function(t,e){return new n(t,e.id,e.keyType,e.type,e.options,e.comment)}},function(t,e,r){\"use strict\";t.exports=o;var i=r(6),s=(i.LongBits,i.utf8);function n(t,e){return RangeError(\"index out of range: \"+t.pos+\" + \"+(e||1)+\" > \"+t.len)}function o(t){this.buf=t,this.pos=0,this.len=t.length}var a,f=\"undefined\"!=typeof Uint8Array?function(t){if(t instanceof Uint8Array||Array.isArray(t))return new o(t);throw Error(\"illegal buffer\")}:function(t){if(Array.isArray(t))return new o(t);throw Error(\"illegal buffer\")};function h(t,e){return(t[e-4]|t[e-3]<<8|t[e-2]<<16|t[e-1]<<24)>>>0}o.create=i.Buffer?function(t){return(o.create=function(t){return i.Buffer.isBuffer(t)?new(void 0)(t):f(t)})(t)}:f,o.prototype._slice=i.Array.prototype.subarray||i.Array.prototype.slice,o.prototype.uint32=(a=4294967295,function(){if(a=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return a;if(a=(a|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return a;if(a=(a|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return a;if(a=(a|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return a;if(a=(a|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return a;if((this.pos+=5)>this.len)throw this.pos=this.len,n(this,10);return a}),o.prototype.int32=function(){return 0|this.uint32()},o.prototype.sint32=function(){var t=this.uint32();return t>>>1^-(1&t)|0},o.prototype.bool=function(){return 0!==this.uint32()},o.prototype.fixed32=function(){if(this.pos+4>this.len)throw n(this,4);return h(this.buf,this.pos+=4)},o.prototype.sfixed32=function(){if(this.pos+4>this.len)throw n(this,4);return 0|h(this.buf,this.pos+=4)},o.prototype.float=function(){if(this.pos+4>this.len)throw n(this,4);var t=i.float.readFloatLE(this.buf,this.pos);return this.pos+=4,t},o.prototype.double=function(){if(this.pos+8>this.len)throw n(this,4);var t=i.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,t},o.prototype.bytes=function(){var t=this.uint32(),e=this.pos,r=this.pos+t;if(r>this.len)throw n(this,t);return this.pos+=t,Array.isArray(this.buf)?this.buf.slice(e,r):e===r?new this.buf.constructor(0):this._slice.call(this.buf,e,r)},o.prototype.string=function(){var t=this.bytes();return s.read(t,0,t.length)},o.prototype.skip=function(t){if(\"number\"==typeof t){if(this.pos+t>this.len)throw n(this,t);this.pos+=t}else do{if(this.pos>=this.len)throw n(this)}while(128&this.buf[this.pos++]);return this},o.prototype.skipType=function(t){switch(t){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;4!=(t=7&this.uint32());)this.skipType(t);break;case 5:this.skip(4);break;default:throw Error(\"invalid wire type \"+t+\" at offset \"+this.pos)}return this}},function(t,e,r){\"use strict\";t.exports=function(t){var e=n.codegen([\"r\",\"l\"],t.name+\"$decode\")(\"if(!(r instanceof Reader))\")(\"r=Reader.create(r)\")(\"var c=l===undefined?r.len:r.pos+l,m=new this.ctor\"+(t.fieldsArray.filter(function(t){return t.map}).length?\",k\":\"\"))(\"while(r.pos<c){\")(\"var t=r.uint32()\");t.group&&e(\"if((t&7)===4)\")(\"break\");e(\"switch(t>>>3){\");for(var r=0;r<t.fieldsArray.length;++r){var a=t._fieldsArray[r].resolve(),f=a.resolvedType instanceof i?\"int32\":a.type,h=\"m\"+n.safeProp(a.name);e(\"case %i:\",a.id),a.map?(e(\"r.skip().pos++\")(\"if(%s===util.emptyObject)\",h)(\"%s={}\",h)(\"k=r.%s()\",a.keyType)(\"r.pos++\"),void 0!==s.long[a.keyType]?void 0===s.basic[f]?e('%s[typeof k===\"object\"?util.longToHash(k):k]=types[%i].decode(r,r.uint32())',h,r):e('%s[typeof k===\"object\"?util.longToHash(k):k]=r.%s()',h,f):void 0===s.basic[f]?e(\"%s[k]=types[%i].decode(r,r.uint32())\",h,r):e(\"%s[k]=r.%s()\",h,f)):a.repeated?(e(\"if(!(%s&&%s.length))\",h,h)(\"%s=[]\",h),void 0!==s.packed[f]&&e(\"if((t&7)===2){\")(\"var c2=r.uint32()+r.pos\")(\"while(r.pos<c2)\")(\"%s.push(r.%s())\",h,f)(\"}else\"),void 0===s.basic[f]?e(a.resolvedType.group?\"%s.push(types[%i].decode(r))\":\"%s.push(types[%i].decode(r,r.uint32()))\",h,r):e(\"%s.push(r.%s())\",h,f)):void 0===s.basic[f]?e(a.resolvedType.group?\"%s=types[%i].decode(r)\":\"%s=types[%i].decode(r,r.uint32())\",h,r):e(\"%s=r.%s()\",h,f),e(\"break\")}for(e(\"default:\")(\"r.skipType(t&7)\")(\"break\")(\"}\")(\"}\"),r=0;r<t._fieldsArray.length;++r){var l=t._fieldsArray[r];l.required&&e(\"if(!m.hasOwnProperty(%j))\",l.name)(\"throw util.ProtocolError(%j,{instance:m})\",o(l))}return e(\"return m\")};var i=r(3),s=r(5),n=r(0);function o(t){return\"missing required '\"+t.name+\"'\"}},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0}),e.default={nested:{com:{nested:{opensource:{nested:{svga:{options:{objc_class_prefix:\"SVGAProto\",java_package:\"com.opensource.svgaplayer\"},nested:{MovieParams:{fields:{viewBoxWidth:{type:\"float\",id:1},viewBoxHeight:{type:\"float\",id:2},fps:{type:\"int32\",id:3},frames:{type:\"int32\",id:4}}},SpriteEntity:{fields:{imageKey:{type:\"string\",id:1},frames:{rule:\"repeated\",type:\"FrameEntity\",id:2}}},Layout:{fields:{x:{type:\"float\",id:1},y:{type:\"float\",id:2},width:{type:\"float\",id:3},height:{type:\"float\",id:4}}},Transform:{fields:{a:{type:\"float\",id:1},b:{type:\"float\",id:2},c:{type:\"float\",id:3},d:{type:\"float\",id:4},tx:{type:\"float\",id:5},ty:{type:\"float\",id:6}}},ShapeEntity:{oneofs:{args:{oneof:[\"shape\",\"rect\",\"ellipse\"]}},fields:{type:{type:\"ShapeType\",id:1},shape:{type:\"ShapeArgs\",id:2},rect:{type:\"RectArgs\",id:3},ellipse:{type:\"EllipseArgs\",id:4},styles:{type:\"ShapeStyle\",id:10},transform:{type:\"Transform\",id:11}},nested:{ShapeType:{values:{SHAPE:0,RECT:1,ELLIPSE:2,KEEP:3}},ShapeArgs:{fields:{d:{type:\"string\",id:1}}},RectArgs:{fields:{x:{type:\"float\",id:1},y:{type:\"float\",id:2},width:{type:\"float\",id:3},height:{type:\"float\",id:4},cornerRadius:{type:\"float\",id:5}}},EllipseArgs:{fields:{x:{type:\"float\",id:1},y:{type:\"float\",id:2},radiusX:{type:\"float\",id:3},radiusY:{type:\"float\",id:4}}},ShapeStyle:{fields:{fill:{type:\"RGBAColor\",id:1},stroke:{type:\"RGBAColor\",id:2},strokeWidth:{type:\"float\",id:3},lineCap:{type:\"LineCap\",id:4},lineJoin:{type:\"LineJoin\",id:5},miterLimit:{type:\"float\",id:6},lineDashI:{type:\"float\",id:7},lineDashII:{type:\"float\",id:8},lineDashIII:{type:\"float\",id:9}},nested:{RGBAColor:{fields:{r:{type:\"float\",id:1},g:{type:\"float\",id:2},b:{type:\"float\",id:3},a:{type:\"float\",id:4}}},LineCap:{values:{LineCap_BUTT:0,LineCap_ROUND:1,LineCap_SQUARE:2}},LineJoin:{values:{LineJoin_MITER:0,LineJoin_ROUND:1,LineJoin_BEVEL:2}}}}}},FrameEntity:{fields:{alpha:{type:\"float\",id:1},layout:{type:\"Layout\",id:2},transform:{type:\"Transform\",id:3},clipPath:{type:\"string\",id:4},shapes:{rule:\"repeated\",type:\"ShapeEntity\",id:5}}},MovieEntity:{fields:{version:{type:\"string\",id:1},params:{type:\"MovieParams\",id:2},images:{keyType:\"string\",type:\"bytes\",id:3},sprites:{rule:\"repeated\",type:\"SpriteEntity\",id:4}}}}}}}}}}}},function(t,e){\n/** @license zlib.js 2012 - imaya [ https://github.com/imaya/zlib.js ] The MIT License */\n(function(){\"use strict\";var t=void 0,e=this;function r(r,i){var s,n=r.split(\".\"),o=e;!(n[0]in o)&&o.execScript&&o.execScript(\"var \"+n[0]);for(;n.length&&(s=n.shift());)n.length||i===t?o=o[s]?o[s]:o[s]={}:o[s]=i}var i=\"undefined\"!=typeof Uint8Array&&\"undefined\"!=typeof Uint16Array&&\"undefined\"!=typeof Uint32Array&&\"undefined\"!=typeof DataView;function s(t){var e,r,s,n,o,a,f,h,l,u,p=t.length,d=0,c=Number.POSITIVE_INFINITY;for(h=0;h<p;++h)t[h]>d&&(d=t[h]),t[h]<c&&(c=t[h]);for(e=1<<d,r=new(i?Uint32Array:Array)(e),s=1,n=0,o=2;s<=d;){for(h=0;h<p;++h)if(t[h]===s){for(a=0,f=n,l=0;l<s;++l)a=a<<1|1&f,f>>=1;for(u=s<<16|h,l=a;l<e;l+=o)r[l]=u;++n}++s,n<<=1,o<<=1}return[r,d,c]}function n(t,e){switch(this.g=[],this.h=32768,this.d=this.f=this.a=this.l=0,this.input=i?new Uint8Array(t):t,this.m=!1,this.i=a,this.r=!1,!e&&(e={})||(e.index&&(this.a=e.index),e.bufferSize&&(this.h=e.bufferSize),e.bufferType&&(this.i=e.bufferType),e.resize&&(this.r=e.resize)),this.i){case o:this.b=32768,this.c=new(i?Uint8Array:Array)(32768+this.h+258);break;case a:this.b=0,this.c=new(i?Uint8Array:Array)(this.h),this.e=this.z,this.n=this.v,this.j=this.w;break;default:throw Error(\"invalid inflate mode\")}}var o=0,a=1,f={t:o,s:a};n.prototype.k=function(){for(;!this.m;){var e=S(this,3);switch(1&e&&(this.m=!0),e>>>=1){case 0:var r=this.input,n=this.a,f=this.c,h=this.b,l=r.length,u=t,d=f.length,c=t;if(this.d=this.f=0,n+1>=l)throw Error(\"invalid uncompressed block header: LEN\");if(u=r[n++]|r[n++]<<8,n+1>=l)throw Error(\"invalid uncompressed block header: NLEN\");if(u===~(r[n++]|r[n++]<<8))throw Error(\"invalid uncompressed block header: length verify\");if(n+u>r.length)throw Error(\"input buffer is broken\");switch(this.i){case o:for(;h+u>f.length;){if(u-=c=d-h,i)f.set(r.subarray(n,n+c),h),h+=c,n+=c;else for(;c--;)f[h++]=r[n++];this.b=h,f=this.e(),h=this.b}break;case a:for(;h+u>f.length;)f=this.e({p:2});break;default:throw Error(\"invalid inflate mode\")}if(i)f.set(r.subarray(n,n+u),h),h+=u,n+=u;else for(;u--;)f[h++]=r[n++];this.a=n,this.b=h,this.c=f;break;case 1:this.j(_,x);break;case 2:var y,v,m,b,g=S(this,5)+257,A=S(this,5)+1,w=S(this,4)+4,k=new(i?Uint8Array:Array)(p.length),O=t,E=t,T=t,N=t,I=t;for(I=0;I<w;++I)k[p[I]]=S(this,3);if(!i)for(I=w,w=k.length;I<w;++I)k[p[I]]=0;for(y=s(k),O=new(i?Uint8Array:Array)(g+A),I=0,b=g+A;I<b;)switch(E=j(this,y),E){case 16:for(N=3+S(this,2);N--;)O[I++]=T;break;case 17:for(N=3+S(this,3);N--;)O[I++]=0;T=0;break;case 18:for(N=11+S(this,7);N--;)O[I++]=0;T=0;break;default:T=O[I++]=E}v=s(i?O.subarray(0,g):O.slice(0,g)),m=s(i?O.subarray(g):O.slice(g)),this.j(v,m);break;default:throw Error(\"unknown BTYPE: \"+e)}}return this.n()};var h,l,u=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],p=i?new Uint16Array(u):u,d=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,258,258],c=i?new Uint16Array(d):d,y=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0],v=i?new Uint8Array(y):y,m=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],b=i?new Uint16Array(m):m,g=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],A=i?new Uint8Array(g):g,w=new(i?Uint8Array:Array)(288);for(h=0,l=w.length;h<l;++h)w[h]=143>=h?8:255>=h?9:279>=h?7:8;var k,O,_=s(w),E=new(i?Uint8Array:Array)(30);for(k=0,O=E.length;k<O;++k)E[k]=5;var x=s(E);function S(t,e){for(var r,i=t.f,s=t.d,n=t.input,o=t.a,a=n.length;s<e;){if(o>=a)throw Error(\"input buffer is broken\");i|=n[o++]<<s,s+=8}return r=i&(1<<e)-1,t.f=i>>>e,t.d=s-e,t.a=o,r}function j(t,e){for(var r,i,s=t.f,n=t.d,o=t.input,a=t.a,f=o.length,h=e[0],l=e[1];n<l&&!(a>=f);)s|=o[a++]<<n,n+=8;if((i=(r=h[s&(1<<l)-1])>>>16)>n)throw Error(\"invalid code length: \"+i);return t.f=s>>i,t.d=n-i,t.a=a,65535&r}function T(t,e){var r,i;switch(this.input=t,this.a=0,!e&&(e={})||(e.index&&(this.a=e.index),e.verify&&(this.A=e.verify)),r=t[this.a++],i=t[this.a++],15&r){case N:this.method=N;break;default:throw Error(\"unsupported compression method\")}if(0!=((r<<8)+i)%31)throw Error(\"invalid fcheck flag:\"+((r<<8)+i)%31);if(32&i)throw Error(\"fdict flag is not supported\");this.q=new n(t,{index:this.a,bufferSize:e.bufferSize,bufferType:e.bufferType,resize:e.resize})}n.prototype.j=function(t,e){var r=this.c,i=this.b;this.o=t;for(var s,n,o,a,f=r.length-258;256!==(s=j(this,t));)if(256>s)i>=f&&(this.b=i,r=this.e(),i=this.b),r[i++]=s;else for(a=c[n=s-257],0<v[n]&&(a+=S(this,v[n])),s=j(this,e),o=b[s],0<A[s]&&(o+=S(this,A[s])),i>=f&&(this.b=i,r=this.e(),i=this.b);a--;)r[i]=r[i++-o];for(;8<=this.d;)this.d-=8,this.a--;this.b=i},n.prototype.w=function(t,e){var r=this.c,i=this.b;this.o=t;for(var s,n,o,a,f=r.length;256!==(s=j(this,t));)if(256>s)i>=f&&(f=(r=this.e()).length),r[i++]=s;else for(a=c[n=s-257],0<v[n]&&(a+=S(this,v[n])),s=j(this,e),o=b[s],0<A[s]&&(o+=S(this,A[s])),i+a>f&&(f=(r=this.e()).length);a--;)r[i]=r[i++-o];for(;8<=this.d;)this.d-=8,this.a--;this.b=i},n.prototype.e=function(){var t,e,r=new(i?Uint8Array:Array)(this.b-32768),s=this.b-32768,n=this.c;if(i)r.set(n.subarray(32768,r.length));else for(t=0,e=r.length;t<e;++t)r[t]=n[t+32768];if(this.g.push(r),this.l+=r.length,i)n.set(n.subarray(s,s+32768));else for(t=0;32768>t;++t)n[t]=n[s+t];return this.b=32768,n},n.prototype.z=function(t){var e,r,s,n=this.input.length/this.a+1|0,o=this.input,a=this.c;return t&&(\"number\"==typeof t.p&&(n=t.p),\"number\"==typeof t.u&&(n+=t.u)),2>n?r=(s=(o.length-this.a)/this.o[2]/2*258|0)<a.length?a.length+s:a.length<<1:r=a.length*n,i?(e=new Uint8Array(r)).set(a):e=a,this.c=e},n.prototype.n=function(){var t,e,r,s,n,o=0,a=this.c,f=this.g,h=new(i?Uint8Array:Array)(this.l+(this.b-32768));if(0===f.length)return i?this.c.subarray(32768,this.b):this.c.slice(32768,this.b);for(e=0,r=f.length;e<r;++e)for(s=0,n=(t=f[e]).length;s<n;++s)h[o++]=t[s];for(e=32768,r=this.b;e<r;++e)h[o++]=a[e];return this.g=[],this.buffer=h},n.prototype.v=function(){var t,e=this.b;return i?this.r?(t=new Uint8Array(e)).set(this.c.subarray(0,e)):t=this.c.subarray(0,e):(this.c.length>e&&(this.c.length=e),t=this.c),this.buffer=t},T.prototype.k=function(){var t,e,r=this.input;if(t=this.q.k(),this.a=this.q.a,this.A){e=(r[this.a++]<<24|r[this.a++]<<16|r[this.a++]<<8|r[this.a++])>>>0;var i=t;if(\"string\"==typeof i){var s,n,o=i.split(\"\");for(s=0,n=o.length;s<n;s++)o[s]=(255&o[s].charCodeAt(0))>>>0;i=o}for(var a,f=1,h=0,l=i.length,u=0;0<l;){l-=a=1024<l?1024:l;do{h+=f+=i[u++]}while(--a);f%=65521,h%=65521}if(e!==(h<<16|f)>>>0)throw Error(\"invalid adler-32 checksum\")}return t};var N=8;r(\"Zlib.Inflate\",T),r(\"Zlib.Inflate.prototype.decompress\",T.prototype.k);var I,B,F,D,M={ADAPTIVE:f.s,BLOCK:f.t};if(Object.keys)I=Object.keys(M);else for(B in I=[],F=0,M)I[F++]=B;for(F=0,D=I.length;F<D;++F)r(\"Zlib.Inflate.BufferType.\"+(B=I[F]),M[B])}).call(this)},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0}),e.default=function(t){for(var e=[],r=0;r<t.length;r+=32768)e.push(String.fromCharCode.apply(null,t.subarray(r,r+32768)));return e.join(\"\")}},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=r(27),s=function(t,e){this.videoSize={width:0,height:0},this.images={},this.dynamicElements={},this.sprites=[],this.version=t.version,this.videoSize.width=t.params.viewBoxWidth||0,this.videoSize.height=t.params.viewBoxHeight||0,this.FPS=t.params.fps||20,this.frames=t.params.frames||0,t.sprites instanceof Array&&(this.sprites=t.sprites.map(function(t){return new i.default(t)})),e&&(this.images=e)};e.default=s},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=r(28),s=function(t){this.frames=[],this.imageKey=t.imageKey,t.frames&&(this.frames=t.frames.map(function(t){return new i.default(t)}))};e.default=s},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=r(29),s=function(t,e,r,i,s,n){return{a:t,b:e,c:r,d:i,tx:s,ty:n}},n=function(t,e,r,i){return{x:t,y:e,width:r,height:i}},o=function(){function t(e){this.alpha=0,this.transform=s(1,0,0,1,0,0),this.nx=0,this.ny=0,this.layout=n(0,0,0,0),this.shapes=[],this.alpha=parseFloat(e.alpha)||0,e.layout&&(this.layout=n(parseFloat(e.layout.x)||0,parseFloat(e.layout.y)||0,parseFloat(e.layout.width)||0,parseFloat(e.layout.height)||0)),e.transform&&(this.transform=s(parseFloat(e.transform.a)||1,parseFloat(e.transform.b)||0,parseFloat(e.transform.c)||0,parseFloat(e.transform.d)||1,parseFloat(e.transform.tx)||0,parseFloat(e.transform.ty)||0)),e.clipPath&&e.clipPath.length>0&&(this.maskPath=new i.default(e.clipPath,void 0,{fill:\"#000000\"})),e.shapes&&(e.shapes instanceof Array&&e.shapes.forEach(function(t){switch(t.pathArgs=t.args,t.type){case 0:t.type=\"shape\",t.pathArgs=t.shape;break;case 1:t.type=\"rect\",t.pathArgs=t.rect;break;case 2:t.type=\"ellipse\",t.pathArgs=t.ellipse;break;case 3:t.type=\"keep\"}if(t.styles){t.styles.fill&&(\"number\"==typeof t.styles.fill.r&&(t.styles.fill[0]=t.styles.fill.r),\"number\"==typeof t.styles.fill.g&&(t.styles.fill[1]=t.styles.fill.g),\"number\"==typeof t.styles.fill.b&&(t.styles.fill[2]=t.styles.fill.b),\"number\"==typeof t.styles.fill.a&&(t.styles.fill[3]=t.styles.fill.a)),t.styles.stroke&&(\"number\"==typeof t.styles.stroke.r&&(t.styles.stroke[0]=t.styles.stroke.r),\"number\"==typeof t.styles.stroke.g&&(t.styles.stroke[1]=t.styles.stroke.g),\"number\"==typeof t.styles.stroke.b&&(t.styles.stroke[2]=t.styles.stroke.b),\"number\"==typeof t.styles.stroke.a&&(t.styles.stroke[3]=t.styles.stroke.a));var e=t.styles.lineDash||[];switch(t.styles.lineDashI>0&&e.push(t.styles.lineDashI),t.styles.lineDashII>0&&(e.length<1&&e.push(0),e.push(t.styles.lineDashII),e.push(0)),t.styles.lineDashIII>0&&(e.length<2&&(e.push(0),e.push(0)),e[2]=t.styles.lineDashIII),t.styles.lineDash=e,t.styles.lineJoin){case 0:t.styles.lineJoin=\"miter\";break;case 1:t.styles.lineJoin=\"round\";break;case 2:t.styles.lineJoin=\"bevel\"}switch(t.styles.lineCap){case 0:t.styles.lineCap=\"butt\";break;case 1:t.styles.lineCap=\"round\";break;case 2:t.styles.lineCap=\"square\"}}}),e.shapes[0]&&\"keep\"===e.shapes[0].type?this.shapes=t.lastShapes:(t.lastShapes=e.shapes,this.shapes=e.shapes));var r=this.transform.a*this.layout.x+this.transform.c*this.layout.y+this.transform.tx,o=this.transform.a*(this.layout.x+this.layout.width)+this.transform.c*this.layout.y+this.transform.tx,a=this.transform.a*this.layout.x+this.transform.c*(this.layout.y+this.layout.height)+this.transform.tx,f=this.transform.a*(this.layout.x+this.layout.width)+this.transform.c*(this.layout.y+this.layout.height)+this.transform.tx,h=this.transform.b*this.layout.x+this.transform.d*this.layout.y+this.transform.ty,l=this.transform.b*(this.layout.x+this.layout.width)+this.transform.d*this.layout.y+this.transform.ty,u=this.transform.b*this.layout.x+this.transform.d*(this.layout.y+this.layout.height)+this.transform.ty,p=this.transform.b*(this.layout.x+this.layout.width)+this.transform.d*(this.layout.y+this.layout.height)+this.transform.ty;this.nx=Math.min(Math.min(a,f),Math.min(r,o)),this.ny=Math.min(Math.min(u,p),Math.min(h,l))}return t.lastShapes=\"\",t}();e.default=o},function(t,e,r){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=function(t,e,r){this._d=t,this._transform=e,this._styles=r};e.default=i}]);",Parser=function(){function Parser(_a){var disableWorker=(void 0===_a?{disableWorker:!1}:_a).disableWorker;disableWorker?(eval(WORKER),this.worker=window.SVGAParserMockWorker):this.worker=new Worker(window.URL.createObjectURL(new Blob([WORKER])));}return Parser.prototype.do=function(e){var t=this,r=new Uint8Array(e,0,4);if(80==r[0]&&75==r[1]&&3==r[2]&&4==r[3])throw "this parser not support version@1.x of svga.";if(!e)throw new Error("Parser Data not found");if(!this.worker)throw new Error("Parser Worker not found");return new Promise(function(r,n){var o;t.worker.disableWorker?((o=t.worker).onmessageCallback=function(e){r(e);},o.onmessage({data:e})):((o=t.worker).postMessage(e),o.onmessage=function(e){var t=e.data;r(t);});})},Parser.prototype.destroy=function(){var e=this.worker;e.terminate&&e.terminate();},Parser}();exports.default=Parser;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n,o,i,s=r(5),a=r(9);!function(e){e.START="start",e.RESUME="resume",e.PROCESS="process",e.PAUSE="pause",e.STOP="stop",e.END="end",e.CLEAR="clear";}(n||(n={})),function(e){e.FORWARDS="forwards",e.BACKWARDS="backwards";}(o||(o={})),function(e){e.FORWARDS="forwards",e.FALLBACKS="fallbacks";}(i||(i={}));var u=function(){function e(e,t,r){if(this.videoItem=t,this.loop=!0,this.fillMode=o.FORWARDS,this.playMode=i.FORWARDS,this.progress=0,this.currentFrame=0,this.totalFramesCount=0,this.startFrame=0,this.endFrame=0,this.cacheFrames=!1,this.intersectionObserverRender=!1,this.intersectionObserverRenderShow=!0,this._intersectionObserver=null,this.$onEvent={start:function(){},resume:function(){},process:function(){},pause:function(){},stop:function(){},end:function(){},clear:function(){}},this.container="string"==typeof e?document.body.querySelector(e):e,!this.container)throw new Error("container undefined.");if(!this.container.getContext)throw new Error("container should be HTMLCanvasElement.");this._renderer=new s.default(this),this._animator=new a.default,this.videoItem&&this.mount(t),r&&this.set(r);}return e.prototype.set=function(e){var t=this;void 0!==e.loop&&(this.loop=e.loop),e.fillMode&&(this.fillMode=e.fillMode),e.playMode&&(this.playMode=e.playMode),void 0!==e.cacheFrames&&(this.cacheFrames=e.cacheFrames),this.startFrame=e.startFrame?e.startFrame:this.startFrame,this.endFrame=e.endFrame?e.endFrame:this.endFrame,void 0!==e.intersectionObserverRender&&(this.intersectionObserverRender=e.intersectionObserverRender),IntersectionObserver&&this.intersectionObserverRender?(this._intersectionObserver=new IntersectionObserver(function(e){e[0].intersectionRatio<=0?t.intersectionObserverRenderShow&&(t.intersectionObserverRenderShow=!1):!t.intersectionObserverRenderShow&&(t.intersectionObserverRenderShow=!0);},{rootMargin:"0px",threshold:[0,.5,1]}),this._intersectionObserver.observe(this.container)):(this._intersectionObserver&&this._intersectionObserver.disconnect(),this.intersectionObserverRender=!1,this.intersectionObserverRenderShow=!0),this._animator.noExecutionDelay=e.noExecutionDelay;},e.prototype.mount=function(e){var t=this;return new Promise(function(r,n){t.currentFrame=0,t.progress=0,t.totalFramesCount=e.frames-1,t.videoItem=e,t._renderer.prepare().then(r),t._renderer.clear(),t._setSize();})},e.prototype.start=function(){if(!this.videoItem)throw new Error("video item undefined.");this._renderer.clear(),this._startAnimation(),this.$onEvent.start();},e.prototype.resume=function(){if(!this.videoItem)throw new Error("video item undefined.");this._startAnimation(),this.$onEvent.resume();},e.prototype.pause=function(){this._animator&&this._animator.stop(),this.$onEvent.pause();},e.prototype.stop=function(){this._animator&&this._animator.stop(),this.currentFrame=0,this._renderer.drawFrame(this.currentFrame),this.$onEvent.stop();},e.prototype.clear=function(){this._animator&&this._animator.stop(),this._renderer.clear(),this.$onEvent.clear();},e.prototype.destroy=function(){this._animator&&this._animator.stop(),this._renderer.clear(),this._animator=null,this._renderer=null,this.videoItem=null;},e.prototype.$on=function(e,t){var r=this;return this.$onEvent[e]=t,"end"===e&&(this._animator.onEnd=function(){return r.$onEvent.end()}),this},e.prototype._startAnimation=function(){var e=this,t=this,r=t.playMode,n=t.totalFramesCount,o=t.startFrame,i=t.endFrame,s=t.videoItem;this.currentFrame===n&&(this.currentFrame=o||0),this._animator.startValue="fallbacks"===r?i||n:o||0,this._animator.endValue="fallbacks"===r?o||0:i||n;var a=s.frames;i>0&&i>o?a=i-o:i<=0&&o>0&&(a=s.frames-o),this._animator.duration=a*(1/s.FPS)*1e3,this._animator.loop=!0===this.loop||this.loop<=0?1/0:!1===this.loop?1:this.loop,this._animator.fillRule="backwards"===this.fillMode?1:0,this._animator.onUpdate=function(t){t=Math.floor(t),e.currentFrame!==t&&(e.currentFrame=t,e.progress=parseFloat((t+1).toString())/parseFloat(s.frames.toString())*100,e._renderer.drawFrame(e.currentFrame),e.$onEvent.process());},this._animator.start(this.currentFrame);},e.prototype._setSize=function(){var e=this.videoItem.videoSize;this.container.width=e.width,this.container.height=e.height;},e}();t.default=u;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n=r(6),o=function(){function e(e){this._bitmapCache={},this._dynamicElements={},this._frames={},this._player=e;var t=this._player.container;this._ofsCanvas=window.OffscreenCanvas?new window.OffscreenCanvas(t.width,t.height):document.createElement("canvas");}return e.prototype.prepare=function(){var e=this;return new Promise(function(t,r){if(e._bitmapCache={},e._player.videoItem.images&&0!=Object.keys(e._player.videoItem.images).length){e._player.videoItem.dynamicElements&&(e._dynamicElements=e._player.videoItem.dynamicElements);var n=0,o=0;for(var i in e._player.videoItem.images){var s=e._player.videoItem.images[i];if("string"!=typeof s||0!==s.indexOf("iVBO")&&0!==s.indexOf("/9j/2w"))e._bitmapCache[i]=s;else {n++;var a=document.createElement("img");a.src="data:image/png;base64,"+s,e._bitmapCache[i]=a,a.onload=function(){++o===n&&t();};}}}else t();})},e.prototype.clear=function(){this._player.container.width=this._player.container.width;},e.prototype.drawFrame=function(e){var t=this._player;if(!t.intersectionObserverRender||t.intersectionObserverRenderShow){this.clear();var r=t.container.getContext("2d");if(this._player.cacheFrames&&this._frames[e]){var o=this._frames[e];r.drawImage(o,0,0,o.width,o.height,0,0,o.width,o.height);}else {var i=this._ofsCanvas;if(i.width=this._player.container.width,i.height=this._player.container.height,n.default(i,this._bitmapCache,this._dynamicElements,this._player.videoItem,this._player.currentFrame),r.drawImage(i,0,0,i.width,i.height,0,0,i.width,i.height),this._player.cacheFrames)if("toDataURL"in i){var s=i.toDataURL(),a=new Image;a.src=s,this._frames[e]=a;}else this._frames[e]=i.transferToImageBitmap();}}},e}();t.default=o;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var n=s(r(0)),o=s(r(7)),i=s(r(8));function s(e){return e&&e.__esModule?e:{default:e}}var a="MLHVCSQRZmlhvcsqrz";function u(e,t){var r=t._styles;void 0!==r&&(r&&r.stroke?e.strokeStyle="rgba(".concat(parseInt((255*r.stroke[0]).toString()),", ").concat(parseInt((255*r.stroke[1]).toString()),", ").concat(parseInt((255*r.stroke[2]).toString()),", ").concat(r.stroke[3],")"):e.strokeStyle="transparent",r&&(e.lineWidth=r.strokeWidth||void 0,e.lineCap=r.lineCap||void 0,e.lineJoin=r.lineJoin||void 0,e.miterLimit=r.miterLimit||void 0),r&&r.fill?e.fillStyle="rgba(".concat(parseInt((255*r.fill[0]).toString()),", ").concat(parseInt((255*r.fill[1]).toString()),", ").concat(parseInt((255*r.fill[2]).toString()),", ").concat(r.fill[3],")"):e.fillStyle="transparent",r&&r.lineDash&&e.setLineDash(r.lineDash));}function c(e,t){e.save(),u(e,t),void 0!==t._transform&&null!==t._transform&&e.transform(t._transform.a||1,t._transform.b||0,t._transform.c||0,t._transform.d||1,t._transform.tx||0,t._transform.ty||0);var r={x:0,y:0,x1:0,y1:0,x2:0,y2:0};e.beginPath(),t._d.replace(/([a-zA-Z])/g,"|||$1 ").replace(/,/g," ").split("|||").forEach(function(t){if(0!=t.length){var n=t.substr(0,1);if(a.indexOf(n)>=0){var o=t.substr(1).trim().split(" ");!function(e,t,r,n){switch(r){case"M":t.x=Number(n[0]),t.y=Number(n[1]),e.moveTo(t.x,t.y);break;case"m":t.x+=Number(n[0]),t.y+=Number(n[1]),e.moveTo(t.x,t.y);break;case"L":t.x=Number(n[0]),t.y=Number(n[1]),e.lineTo(t.x,t.y);break;case"l":t.x+=Number(n[0]),t.y+=Number(n[1]),e.lineTo(t.x,t.y);break;case"H":t.x=Number(n[0]),e.lineTo(t.x,t.y);break;case"h":t.x+=Number(n[0]),e.lineTo(t.x,t.y);break;case"V":t.y=Number(n[0]),e.lineTo(t.x,t.y);break;case"v":t.y+=Number(n[0]),e.lineTo(t.x,t.y);break;case"C":t.x1=Number(n[0]),t.y1=Number(n[1]),t.x2=Number(n[2]),t.y2=Number(n[3]),t.x=Number(n[4]),t.y=Number(n[5]),e.bezierCurveTo(t.x1,t.y1,t.x2,t.y2,t.x,t.y);break;case"c":t.x1=t.x+Number(n[0]),t.y1=t.y+Number(n[1]),t.x2=t.x+Number(n[2]),t.y2=t.y+Number(n[3]),t.x+=Number(n[4]),t.y+=Number(n[5]),e.bezierCurveTo(t.x1,t.y1,t.x2,t.y2,t.x,t.y);break;case"S":t.x1&&t.y1&&t.x2&&t.y2?(t.x1=t.x-t.x2+t.x,t.y1=t.y-t.y2+t.y,t.x2=Number(n[0]),t.y2=Number(n[1]),t.x=Number(n[2]),t.y=Number(n[3]),e.bezierCurveTo(t.x1,t.y1,t.x2,t.y2,t.x,t.y)):(t.x1=Number(n[0]),t.y1=Number(n[1]),t.x=Number(n[2]),t.y=Number(n[3]),e.quadraticCurveTo(t.x1,t.y1,t.x,t.y));break;case"s":t.x1&&t.y1&&t.x2&&t.y2?(t.x1=t.x-t.x2+t.x,t.y1=t.y-t.y2+t.y,t.x2=t.x+Number(n[0]),t.y2=t.y+Number(n[1]),t.x+=Number(n[2]),t.y+=Number(n[3]),e.bezierCurveTo(t.x1,t.y1,t.x2,t.y2,t.x,t.y)):(t.x1=t.x+Number(n[0]),t.y1=t.y+Number(n[1]),t.x+=Number(n[2]),t.y+=Number(n[3]),e.quadraticCurveTo(t.x1,t.y1,t.x,t.y));break;case"Q":t.x1=Number(n[0]),t.y1=Number(n[1]),t.x=Number(n[2]),t.y=Number(n[3]),e.quadraticCurveTo(t.x1,t.y1,t.x,t.y);break;case"q":t.x1=t.x+Number(n[0]),t.y1=t.y+Number(n[1]),t.x+=Number(n[2]),t.y+=Number(n[3]),e.quadraticCurveTo(t.x1,t.y1,t.x,t.y);break;case"A":case"a":break;case"Z":case"z":e.closePath();}}(e,r,n,o);}}}),t._styles&&t._styles.fill?e.fill():t._styles&&t._styles.stroke&&e.stroke(),e.restore();}var l=function(e,t,r,s,a){var l=e.getContext("2d");return s.sprites.forEach(function(e){var s=e.frames[a];if(!(s.alpha<.05)){l.save(),l.globalAlpha=s.alpha,l.transform(s.transform.a||1,s.transform.b||0,s.transform.c||0,s.transform.d||1,s.transform.tx||0,s.transform.ty||0);var h=t[e.imageKey];h&&(void 0!==s.maskPath&&null!==s.maskPath&&(s.maskPath._styles=void 0,c(l,s.maskPath),l.clip()),l.drawImage(h,0,0));var f=r[e.imageKey];f&&l.drawImage(f,(s.layout.width-f.width)/2,(s.layout.height-f.height)/2),s.shapes&&s.shapes.forEach(function(e){"shape"===e.type&&e.pathArgs&&e.pathArgs.d?c(l,new n.default(e.pathArgs.d,e.transform,e.styles)):"ellipse"===e.type&&e.pathArgs?function(e,t){e.save(),u(e,t),void 0!==t._transform&&null!==t._transform&&e.transform(t._transform.a||1,t._transform.b||0,t._transform.c||0,t._transform.d||1,t._transform.tx||0,t._transform.ty||0);var r=t._x-t._radiusX,n=t._y-t._radiusY,o=2*t._radiusX,i=2*t._radiusY,s=o/2*.5522848,a=i/2*.5522848,c=r+o,l=n+i,h=r+o/2,f=n+i/2;e.beginPath(),e.moveTo(r,f),e.bezierCurveTo(r,f-a,h-s,n,h,n),e.bezierCurveTo(h+s,n,c,f-a,c,f),e.bezierCurveTo(c,f+a,h+s,l,h,l),e.bezierCurveTo(h-s,l,r,f+a,r,f),t._styles&&t._styles.fill?e.fill():t._styles&&t._styles.stroke&&e.stroke();e.restore();}(l,new o.default(parseFloat(e.pathArgs.x)||0,parseFloat(e.pathArgs.y)||0,parseFloat(e.pathArgs.radiusX)||0,parseFloat(e.pathArgs.radiusY)||0,e.transform,e.styles)):"rect"===e.type&&e.pathArgs&&function(e,t){e.save(),u(e,t),void 0!==t._transform&&null!==t._transform&&e.transform(t._transform.a||1,t._transform.b||0,t._transform.c||0,t._transform.d||1,t._transform.tx||0,t._transform.ty||0);var r=t._x,n=t._y,o=t._width,i=t._height,s=t._cornerRadius;o<2*s&&(s=o/2);i<2*s&&(s=i/2);e.beginPath(),e.moveTo(r+s,n),e.arcTo(r+o,n,r+o,n+i,s),e.arcTo(r+o,n+i,r,n+i,s),e.arcTo(r,n+i,r,n,s),e.arcTo(r,n,r+o,n,s),e.closePath(),t._styles&&t._styles.fill?e.fill():t._styles&&t._styles.stroke&&e.stroke();e.restore();}(l,new i.default(parseFloat(e.pathArgs.x)||0,parseFloat(e.pathArgs.y)||0,parseFloat(e.pathArgs.width)||0,parseFloat(e.pathArgs.height)||0,parseFloat(e.pathArgs.cornerRadius)||0,e.transform,e.styles));}),l.restore();}}),e};t.default=l;},function(e,t,r){var n,o=(n=function(e,t){return (n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t;}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);})(e,t)},function(e,t){function r(){this.constructor=e;}n(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r);});Object.defineProperty(t,"__esModule",{value:!0});var i=function(e){function t(t,r,n,o,i,s){var a=e.call(this)||this;return a._x=t,a._y=r,a._radiusX=n,a._radiusY=o,a._transform=i,a._styles=s,a}return o(t,e),t}(r(0).default);t.default=i;},function(e,t,r){var n,o=(n=function(e,t){return (n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t;}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);})(e,t)},function(e,t){function r(){this.constructor=e;}n(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r);});Object.defineProperty(t,"__esModule",{value:!0});var i=function(e){function t(t,r,n,o,i,s,a){var u=e.call(this)||this;return u._x=t,u._y=r,u._width=n,u._height=o,u._cornerRadius=i,u._transform=s,u._styles=a,u}return o(t,e),t}(r(0).default);t.default=i;},function(e,t,r){Object.defineProperty(t,"__esModule",{value:!0});var n=function(){function e(){this._currentTimeMillsecond=function(){return "undefined"==typeof performance?(new Date).getTime():performance.now()},this.noExecutionDelay=!1,this.startValue=0,this.endValue=0,this.duration=0,this.loop=1,this.fillRule=0,this.onStart=function(){},this.onUpdate=function(){},this.onEnd=function(){},this._isRunning=!1,this._mStartTime=0,this._currentFrication=0,this._worker=null;}return e.prototype.start=function(e){this.doStart(e);},e.prototype.stop=function(){this._doStop();},Object.defineProperty(e.prototype,"animatedValue",{get:function(){return (this.endValue-this.startValue)*this._currentFrication+this.startValue},enumerable:!1,configurable:!0}),e.prototype.doStart=function(e){this._isRunning=!0,this._mStartTime=this._currentTimeMillsecond(),e&&(this._mStartTime-=e/(this.endValue-this.startValue)*this.duration),this._currentFrication=0,this.noExecutionDelay&&null===this._worker&&(this._worker=new Worker(window.URL.createObjectURL(new Blob(["onmessage = function () {\n  setTimeout(function() {postMessage(null)}, 1 / 60)\n}"])))),this.onStart(),this._doFrame();},e.prototype._doStop=function(){this._isRunning=!1,null!==this._worker&&(this._worker.terminate(),this._worker=null);},e.prototype._doFrame=function(){this._isRunning&&(this._doDeltaTime(this._currentTimeMillsecond()-this._mStartTime),this._isRunning&&(this._worker?(this._worker.onmessage=this._doFrame.bind(this),this._worker.postMessage(null)):window.requestAnimationFrame(this._doFrame.bind(this))));},e.prototype._doDeltaTime=function(e){e>=this.duration*this.loop?(this._currentFrication=1===this.fillRule?0:1,this._isRunning=!1):this._currentFrication=e%this.duration/this.duration,this.onUpdate(this.animatedValue),!1===this._isRunning&&(null!==this._worker&&(this._worker.terminate(),this._worker=null),this.onEnd());},e}();t.default=n;}]).default});
});

/**
 * Created by rockyl on 2020/12/26.
 */
const disableWorker = !!window['svga_parser_disable_worker'];
const cache = {};
const loadings = {};
const loaderCache = [];
/**
 * 加载svga
 * @ctype PROCESS
 * @description 加载svga
 * @param {string | string[]} urls - 地址或地址数组
 * @param {function} [onProcess] - 加载进度回调
 * @param {function} [onComplete] - 加载完成回调
 * @param {boolean} [parallelMode=false] - 并行加载，可缩短近一半加载时间，但是会导致卡顿，酌情开启
 * @returns
 * svgaDatas VideoEntity[] svga视频数据
 * @example 预加载一个svga
 * loadSvga('xxx.svga').then(()=>{
 *   console.log('加载完成')
 * })
 * <SvgaPlayer src="xxx.svga"/> //使用同一个url即可使用缓存中的数据
 * @example 预加载一组svga
 * loadSvga(['xxx.svga', 'yyy.svga'], (loaded, total) => {
 *   console.log('onProcess:', loaded, total)
 * }, ()=>{
 *   console.log('onComplete')
 * }).then(()=>{
 *   console.log('加载完成')
 * })
 * <SvgaPlayer src="xxx.svga"/> //使用同一个url即可使用缓存中的数据
 */
async function loadSvga(urls, onProcess, onComplete, parallelMode = false) {
    let results = [];
    if (typeof urls === 'string') {
        results.push(await loadSvgaOnce(urls).then(ve => {
            try {
                onProcess && onProcess(1, 1);
                onComplete && onComplete();
            }
            catch (e) {
                console.warn(e);
            }
            return ve;
        }));
    }
    else {
        let total = urls.length, loaded = 0;
        if (parallelMode) {
            results = await Promise.all(urls.map(url => {
                return loadSvgaOnce(url).then(ve => {
                    try {
                        loaded++;
                        onProcess && onProcess(loaded, total);
                        if (loaded >= total) {
                            onComplete && onComplete();
                        }
                    }
                    catch (e) {
                        console.warn(e);
                    }
                    return ve;
                });
            }));
        }
        else {
            for (let url of urls) {
                results.push(await loadSvgaOnce(url).then(ve => {
                    try {
                        loaded++;
                        onProcess && onProcess(loaded, total);
                        if (loaded >= total) {
                            onComplete && onComplete();
                        }
                    }
                    catch (e) {
                        console.warn(e);
                    }
                    return ve;
                }));
            }
        }
    }
    return results;
}
async function loadSvgaOnce(url) {
    let svgaData = cache[url];
    if (!svgaData) {
        let loadingQs = loadings[url];
        if (!loadingQs) {
            loadingQs = loadings[url] = [];
            svgaData = await doLoadSvga(url);
            cache[url] = svgaData;
            delete loadings[url];
            for (let { resolve } of loadingQs) {
                resolve(svgaData);
            }
        }
        else {
            return new Promise((resolve, reject) => {
                loadingQs.push({ resolve, reject });
            });
        }
    }
    return svgaData;
}
async function doLoadSvga(url) {
    let loader = loaderCache.length > 0 ? loaderCache.pop() : {
        downloader: new svga_lite_min.Downloader(),
        // @ts-ignore
        parser: new svga_lite_min.Parser({ disableWorker }),
    };
    const { downloader, parser } = loader;
    const fileData = await downloader.get(url);
    const svgaData = await parser.do(fileData);
    for (let { frames } of svgaData.sprites) {
        for (let { transform } of frames) {
            transform._tx = transform.tx;
            transform._ty = transform.ty;
        }
    }
    loaderCache.push(loader);
    return svgaData;
}

/**
 * Created by rockyl on 2020/9/19.
 *
 * https://github.com/svga/SVGAPlayer-Web-Lite
 */
/**
 * Svga播放器
 * @ctype DOM_COMPONENT
 * @desc Svga播放器
 */
function Svga({ src, autoPlay = true, preview = true, loop = 0, playMode = 'forwards', fillMode = 'forwards', startFrame = 1, endFrame = 0, className, style, onGotPlayer, onVideoDidMount, onError, onStart, onPause, onStop, onEnd, onClear, onProcess, onClick, }, ref) {
    const [player, setPlayer] = useState(null);
    const canvasRef = useRef();
    useImperativeHandle(ref, () => ({
        getPlayer() {
            return player;
        },
        start() {
            player && player.videoItem && player.start();
        },
        pause() {
            player && player.videoItem && player.pause();
        },
        stop() {
            player && player.videoItem && player.stop();
        },
        clear() {
            player && player.videoItem && player.clear();
        },
        reset() {
            updateSrc();
        },
        async replaceImage(name, img) {
            if (player && player.videoItem) {
                let imgEl;
                if (typeof img === 'string') {
                    imgEl = await loadImage(img);
                }
                else {
                    imgEl = img;
                }
                player._renderer._bitmapCache[name] = imgEl;
                return imgEl;
            }
        },
        async addImage(parentName, targetName, img) {
            if (player && player.videoItem) {
                let videoItem = player.videoItem;
                let parent, target, parentIndex;
                videoItem.sprites.forEach((sprite, index) => {
                    if (sprite.imageKey === parentName) {
                        parent = sprite;
                        parentIndex = index;
                    }
                    if (sprite.imageKey === targetName) {
                        target = sprite;
                    }
                });
                if (!parent) {
                    console.warn(`父节点[${parentName}]不存在`);
                    return;
                }
                if (target) {
                    console.warn(`节点[${targetName}]已存在`);
                }
                else {
                    const imgEl = await this.replaceImage(targetName, img);
                    let targetFrames = JSON.parse(JSON.stringify(parent.frames));
                    for (let { layout, transform } of targetFrames) {
                        layout.width = imgEl.width;
                        layout.height = imgEl.height;
                        transform._tx = transform.tx;
                        transform._ty = transform.ty;
                    }
                    let frame = {
                        imageKey: targetName,
                        frames: targetFrames,
                    };
                    videoItem.sprites.splice(parentIndex + 1, 0, frame);
                }
            }
        },
        removeImage(targetName) {
            if (player && player.videoItem) {
                let videoItem = player.videoItem;
                let target;
                videoItem.sprites.forEach((sprite, index) => {
                    if (sprite.imageKey === targetName) {
                        target = sprite;
                        videoItem.sprites.splice(index, 1);
                    }
                });
                if (!target) {
                    console.warn(`节点[${targetName}]不存在`);
                }
            }
        },
        setImageProps(targetName, props = {}) {
            if (player && player.videoItem) {
                let videoItem = player.videoItem;
                let target;
                videoItem.sprites.forEach((sprite, index) => {
                    if (sprite.imageKey === targetName) {
                        target = sprite;
                    }
                });
                if (!target) {
                    console.warn(`节点[${targetName}]不存在`);
                    return;
                }
                const { offX, offY, alpha, visible } = props;
                for (let frame of target.frames) {
                    if (visible !== undefined) {
                        frame.visible = visible;
                    }
                    if (alpha !== undefined) {
                        frame.alpha = alpha;
                    }
                    const { transform } = frame;
                    if (offX !== undefined) {
                        transform.tx = transform._tx + offX;
                    }
                    if (offY !== undefined) {
                        transform.ty = transform._ty + offY;
                    }
                }
            }
        }
    }));
    useEffect(() => {
        return () => {
            if (player) {
                //player.stop()
                player.clear();
            }
        };
    }, [player]);
    useEffect(() => {
        updateSrc();
    }, [src]);
    useEffect(() => {
        updateConfig();
    }, [loop, playMode, fillMode, startFrame, endFrame]);
    useEffect(() => {
        if (player) {
            player.stop();
            player.start();
        }
    }, [playMode, fillMode]);
    function updateConfig(mPlayer) {
        const p = mPlayer || player;
        p && p.set({
            loop, playMode, fillMode, startFrame, endFrame,
        });
    }
    async function updateSrc() {
        let mPlayer;
        if (!player) {
            mPlayer = new svga_lite_min.Player(canvasRef.current);
            setPlayer(mPlayer);
            mPlayer
                // 开始动画事件回调
                .$on('start', () => {
                onStart && onStart();
            })
                // 暂停动画事件回调
                .$on('pause', () => {
                onPause && onPause();
            })
                // 停止动画事件回调
                .$on('stop', () => {
                onStop && onStop();
            })
                // 动画结束事件回调
                .$on('end', () => {
                onEnd && onEnd();
            })
                // 清空动画事件回调
                .$on('clear', () => {
                onClear && onClear();
            })
                // 动画播放中事件回调
                .$on('process', () => {
                onProcess && onProcess(mPlayer.currentFrame, mPlayer.progress);
            });
        }
        else {
            mPlayer = player;
        }
        onGotPlayer && onGotPlayer(mPlayer);
        try {
            mPlayer.clear();
            updateConfig(mPlayer);
            let svgaDataOrigin = await loadSvgaOnce(src);
            let svgaData = JSON.parse(JSON.stringify(svgaDataOrigin));
            await mPlayer.mount(svgaData);
            onVideoDidMount && onVideoDidMount();
            if (autoPlay) {
                mPlayer.start();
            }
            else if (preview) {
                mPlayer._renderer.drawFrame(startFrame);
            }
        }
        catch (e) {
            console.error(e);
            onError && onError(e);
        }
    }
    function clickCanvas(e) {
        onClick && onClick(e);
    }
    return (React.createElement("canvas", { className: className, style: style, ref: canvasRef, onClick: clickCanvas }));
}
// @ts-ignore
const SvgaPlayer = forwardRef(Svga);

export { SvgaPlayer, loadSvga, loadSvgaOnce };
