import React, { Component } from 'react';
import './lightGreyPop.less';
import { observer } from 'mobx-react';
import store from '../../store';
import modalStore from '../../store/modal';
import skinStore from '../../store/newSkin';
import { SvgaPlayer } from '../SvgaPlayer';
import { _asyncThrottle } from '../../utils/utils';
@observer
class LightGreyPop extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
  }

  handleClose() {
    modalStore.closePop("LightGreyPop")
  }

  handleJoin = _asyncThrottle(() => {
    modalStore.closePop("LightGreyPop")

    const { jumpUrl } = this.props.popData || {}
    if (jumpUrl) {
      if (jumpUrl.indexOf('http') === 0) {
        window.location.href = jumpUrl
      } else {
        wx.miniProgram.navigateTo({ url: jumpUrl });
      }
    }
  })

  render() {
    const { lightGreyPop, common, svga } = skinStore
    const { bg, join_btn, deng } = lightGreyPop
    const { close } = common
    const { pop, light } = svga

    const { name, desc, icon } = this.props.popData || {}

    return <div className="lightGreyPop modal_center">
      <SvgaPlayer className="light" src={light} />
      <SvgaPlayer className="pop" src={pop} />
      <span className="bg" style={{ backgroundImage: `url(${bg})` }} ></span>
      <div className="title">该勋章暂未点亮</div>
      <div className="desc">{desc}</div>
      <span className="deng" style={{ backgroundImage: `url(${deng})` }} ></span>
      <img className="icon" src={icon} alt="" />
      <div className="name">{name}</div>
      <span className="close" onClick={this.handleClose} style={{ backgroundImage: `url(${close})` }} />
      <span className="join_btn" onClick={this.handleJoin} style={{ backgroundImage: `url(${join_btn})` }} />
    </div>
  }
}
export default LightGreyPop;