import {
  makeAutoObservable
} from 'mobx';
import {

} from '../api/api';
import {
  delUrlParam,
  getUrlParam,
  isIos,
} from '../utils';
import Toast from '../components/toast';
import { getQRCode, randomStr, url2Base64, waitTime } from '../utils/utils';
import CryptoJS from 'crypto-js'
import modalStore from './modal';
import { GetCurrSkinId, getCustomShareId } from "../utils/utils";
import { PAGE_MAP } from '../utils/constants';
import { indexApi, join } from "../api/api.js";
export const skinId = GetCurrSkinId() || getCustomShareId();
const store = makeAutoObservable({

  /** 当前页面 */
  curPage:
    {
      // index: PAGE_MAP.HOME_PAGE,
    }[skinId] || PAGE_MAP.HOME_PAGE,

  pageData: {},

  changePage(val) {
    this.curPage = val
  },

  indexInfo: {},
  async getIndexInfo() {
    const res = await indexApi()
    console.log(res)
    if (res.ok) {
      store.indexInfo = res.data || {}
    }
  },

  // 活动时间拦截
  // 结束不拦截 brakeEnd为false
  // 规则奖品始终可以点击 不用调方法 
  checkActivityStatus(brakeStart = true, brakeEnd = true) {
    const activityBaseInfo = store.indexInfo.activityBaseInfo;
    if (activityBaseInfo && activityBaseInfo.startTime && activityBaseInfo.endTime) {
      const startTime = activityBaseInfo.startTime;
      const endTime = activityBaseInfo.endTime;
      const now = new Date().getTime();
      if (now >= startTime && now <= endTime) {
        return true;
      }
      if (brakeStart && now < startTime) {
        Toast('活动暂未开始')
      }
      if (brakeEnd && now > endTime) {
        Toast('活动已经结束')
      }
    }
    Toast('活动异常~')
    return false;
  },
  joinActivity() {
    join({ activityId: '' }).then(res => {
      console.log(res)
      if (res.ok) {
        this.curQuesIndex = 0;
        this.changePage(PAGE_MAP.QUES_PAGE)
      } else {
        Toast(res.msg)
      }
    });
  }
});

export default store;

