import React, { Component } from 'react';
import './prizePage.less';
import { _asyncThrottle, _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import store from '../../store';
import { PAGE_MAP } from '../../utils/constants';
import { observer } from 'mobx-react';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
@observer
class PrizePage extends Component {
  constructor(props) {
    super(props);

    this.state = {
      curTab: 0,
    }
  }

  async componentDidMount() {
    sensorMdExpouse("xcxPage", { pageName: `奖品页` })
  }

  // 切换tab
  toggleTab = _asyncThrottle((index) => {
    this.setState({ curTab: index })
  })

  // 返回
  backHandle = _asyncThrottle(() => {
    sensorMdClick("xcxClick", { pageName: `奖品页`, buttonName: '返回' })
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { curTab } = this.state;
    const { prize_img_bg, tab_active_bg, title, item_bg } = skinStore.prizePage;
    const { back, sub_page_bg_cover, sub_page_bg } = skinStore.common;
    return (
      <div className="prizePage">
        <div className="bg" style={{ 'backgroundImage': `url(${sub_page_bg})` }}></div>
        {/* 返回 */}
        <div className="back" onClick={this.backHandle} style={{ 'backgroundImage': `url(${back})` }}></div>
        {/* 遮罩 */}
        <div className="bg_cover" style={{ 'backgroundImage': `url(${sub_page_bg_cover})` }}></div>
        {/* 标题 */}
        <div className="title" style={{ 'backgroundImage': `url(${title})` }}></div>
        {/* tab */}
        <div className="tab_list">
          {new Array(10).fill(0).map((item, index) => (
            <div
              className={`tab_item ${curTab === index ? 'active' : ''}`}
              onClick={() => this.toggleTab(index)}
              style={{ 'backgroundImage': `url(${curTab === index ? tab_active_bg : ''})` }}
            >财神红包雨星{index + 1}
            </div>
          ))}
        </div>
        {/* 奖品列表 */}
        <div className="prize_list">
          {new Array(20).fill(0).map((item, index) => (
            <div className="prize_item" style={{ 'backgroundImage': `url(${item_bg})` }}>
              <div className="prize_img_box" style={{ 'backgroundImage': `url(${prize_img_bg})` }}>
                <img className="prize_img" src="//yun.duiba.com.cn/polaris/medal4.3c2dd506dd8ee372e3e523e4990254b8f3cfcbf2.png" alt="" />
              </div>
              <div className="prize_info">
                <div className="prize_name">奖品名称奖品名称奖品名称奖品名称${index + 1}</div>
                <div className="prize_desc">奖品描述奖品描述奖品描述奖品描述奖品描述奖品描述奖品描述</div>
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  }
}

export default PrizePage;
