export const PAGE_MAP = {
  HOME_PAGE: 'homePage',
  PRIZE_PAGE: 'prizePage',
}

export const errMessageMap = {
  200009: "奖品已抢完，明天再来吧～",
  200002: "请刷新页面，奖品库存已领完～",
}

/**
 * 渠道参数
 * 1.个险app gxapp
 * 2.个险企微 gxqw
 * 3.寿险小程序 shouxian
 */
export const CHANNEL_PARAMS = {
  /** 个险app */
  GXAPP: "gxapp",
  /** 个险企微 */
  GXQW: "gxqw",
  /** 寿险小程序 */
  SHOUXIAN_MINI: "shouxian",
}

/** 神策 sysSourceName渠道参数 */
export const SYS_SOURCE_CHANNEL = {
 /** 个险app */
 [CHANNEL_PARAMS.GXAPP]: "个险",
 /** 个险企微 */
 [CHANNEL_PARAMS.GXQW]: "个险",
 /** 寿险小程序 */
 [CHANNEL_PARAMS.SHOUXIAN_MINI]: "官微",
}

/** 神策 activitySource渠道参数 */
export const ACTIVITY_SOURCE_CHANNEL = {
 /** 个险app */
 [CHANNEL_PARAMS.GXAPP]: "个险app",
 /** 个险企微 */
 [CHANNEL_PARAMS.GXQW]: "个险企微",
 /** 寿险小程序 */
 [CHANNEL_PARAMS.SHOUXIAN_MINI]: "寿险小程序",
}

export const EVENT_TYPE = {
  CLICK: "click",
  BROWSE: "browse",
}
