import {
  makeAutoObservable
} from 'mobx';

// import CryptoJS from 'crypto-js';
// // const CryptoJS = require('crypto-js');
// const hash = createHash('sha256');

// hash.update(bundle[fileName].source);
// const hashValue = hash.digest('hex').substring(0, 8);

// 公共图片
const _common = {
  close: './assets/common/close.png',
  back: './assets/common/back.png',
  sub_page_bg: './assets/common/sub_page_bg.png',
  sub_page_bg_cover: './assets/common/sub_page_bg_cover.png',
}

// 动效文件
const _svga = {
  home: './assets/svga/home.svga',
  box: './assets/svga/box.svga',
  saoguang: './assets/svga/saoguang.svga',
  huadong: './assets/svga/huadong.svga',
  pop: './assets/svga/pop.svga',
  light: './assets/svga/light.svga',
}


// 首页
const _homePage = {
  bg_type1: './assets/homePage/bg_type1.png',
  bg_type2: './assets/homePage/bg_type2.png',
  tab1: './assets/homePage/tab1.png',
  tab2: './assets/homePage/tab2.png',
  arrow_left: './assets/homePage/arrow_left.png',
  btn_prize: './assets/homePage/btn_prize.png',
  mainbtn: './assets/homePage/mainbtn.png',
  mainbtn_bg: './assets/homePage/mainbtn_bg.png',
  btn_future: './assets/homePage/btn_future.png',
  mainbtn_popover: './assets/homePage/mainbtn_popover.png',
  btn_rule: './assets/homePage/btn_rule.png',
  title: './assets/homePage/title.png',
  btn_share: './assets/homePage/btn_share.png',
}

// 规则
const _rulePop = {
  bg: './assets/rulePop/bg.png',
  light: './assets/rulePop/light.png',
}

// 时光宝箱
const _prizePage = {
  prize_img_bg: './assets/prizePage/prize_img_bg.png',
  tab_active_bg: './assets/prizePage/tab_active_bg.png',
  title: './assets/prizePage/title.png',
  item_bg: './assets/prizePage/item_bg.png',
}

// 未来展品
const _futurePage = {
  prize_img_bg: './assets/futurePage/prize_img_bg.png',
  title: './assets/futurePage/title.png',
  item_bg: './assets/futurePage/item_bg.png',
  btn: './assets/futurePage/btn.png',
}

// 已点亮勋章
const _lightedPop = {
  bg: './assets/lightedPop/bg.png',
  deng: './assets/lightedPop/deng.png',
  know_btn: './assets/lightedPop/know_btn.png',
}

// 未点亮勋章
const _lightGreyPop = {
  bg: './assets/lightGreyPop/bg.png',
  deng: './assets/lightGreyPop/deng.png',
  join_btn: './assets/lightGreyPop/join_btn.png',
}

// 点亮勋章活动结束
const _lightEndPop = {
  bg: './assets/lightEndPop/bg.png',
  know_btn: './assets/lightedPop/know_btn.png',
}

// 新点亮勋章弹窗
const _lightNewPop = {
  bg: './assets/lightNewPop/bg.png',
  draw_btn: './assets/lightNewPop/draw_btn.png',
  prize_box: './assets/lightNewPop/prize_box.png',
}

// 海报
const _posterPop = {
  bg: './assets/posterPop/bg.png',
  code_img_test: './assets/posterPop/code_img_test.png',
}

// 处理图片防止缓存
const dealImg = (obj) => {

  Object.keys(obj)?.map(item => {
    if (typeof obj[item] == 'string') {
      obj[item] = `${obj[item]}?v=${__BUILD_TIME__}`
    } else if (Array.isArray(obj[item])) {
      return dealImg(obj[item])
    }
  })

  return obj
}
let homePage = dealImg(_homePage)
let prizePage = dealImg(_prizePage)
let rulePop = dealImg(_rulePop)
let common = dealImg(_common)
let svga = _svga
let futurePage = dealImg(_futurePage)
let lightedPop = dealImg(_lightedPop)
let lightGreyPop = dealImg(_lightGreyPop)
let lightEndPop = dealImg(_lightEndPop)
let lightNewPop = dealImg(_lightNewPop)
let posterPop = dealImg(_posterPop)

const skinStore = makeAutoObservable({
  homePage,
  prizePage,
  rulePop,
  common,
  svga,
  futurePage,
  lightedPop,
  lightGreyPop,
  lightEndPop,
  lightNewPop,
  posterPop,
})
export default skinStore;
