import React, { Component } from 'react';
import './longImgPop.less';
import { _asyncThrottle, _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import { observer } from 'mobx-react';
import modalStore from '../../store/modal';
import { sensorMdExpouse } from '../../utils/sensorMd';
@observer
class LongImgPop extends Component {
  constructor(props) {
    super(props);

  }

  componentDidMount() {
    sensorMdExpouse("activityPage", { pageName: `${this.props.popData.name}活动预告页` })
  }

  // 返回
  backHandle = _asyncThrottle(() => {
    modalStore.closePop();
  })

  render() {
    const { back } = skinStore.common;
    const { img } = this.props.popData;
    return (
      <div className="longImgPop">
        <img className="img" src={img} alt="" />
        {/* 返回 */}
        <div className="back" onClick={this.backHandle} style={{ 'backgroundImage': `url(${back})` }}></div>
      </div>
    );
  }
}

export default LongImgPop;
