import React, { Component } from 'react';
import './lightNewPop.less';
import { observer } from 'mobx-react';
import store from '../../store';
import modalStore from '../../store/modal';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import skinStore from '../../store/newSkin';
import { SvgaPlayer } from '../SvgaPlayer';
import { _asyncThrottle } from '../../utils/utils';
@observer
class LightNewPop extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    const { newGetMedalInfoList } = this.props.popData || {}
    // 是否一个勋章
    const isOne = newGetMedalInfoList.length === 1

    sensorMdExpouse("PopupExpouse", { pageName: isOne ? `点亮1次勋章弹窗` : `点亮2次及以上勋章弹窗` })
  }

  handleClose = _asyncThrottle(() => {
    const { newGetMedalInfoList } = this.props.popData || {}
    // 是否一个勋章
    const isOne = newGetMedalInfoList.length === 1

    sensorMdClick("PopupClick", { pageName: isOne ? `点亮1次勋章弹窗` : `点亮2次及以上勋章弹窗`, buttonName: '关闭' })
    modalStore.closePop("LightNewPop")
  })

  handleDraw = _asyncThrottle(() => {
    const { newGetMedalInfoList } = this.props.popData || {}
    // 是否一个勋章
    const isOne = newGetMedalInfoList.length === 1

    sensorMdClick("PopupClick", { pageName: isOne ? `点亮1次勋章弹窗` : `点亮2次及以上勋章弹窗`, buttonName: '立即抽奖' })
    modalStore.closePop("LightNewPop")
    // 点击后跳转至【官微大转盘】
    store.jumpDraw()
  })

  render() {
    const { lightNewPop, common, svga } = skinStore
    const { bg, draw_btn, prize_box } = lightNewPop
    const { close } = common
    const { pop, light } = svga

    const { newGetMedalInfoList } = this.props.popData || {}

    // 是否一个勋章
    const isOne = newGetMedalInfoList.length === 1
    const { name, icon, babyCredits } = newGetMedalInfoList[0]

    // 累计保贝值
    const totalBabyCredits = newGetMedalInfoList.reduce((acc, curr) => acc + curr.babyCredits, 0)

    return <div className="lightNewPop modal_center">
      <SvgaPlayer className="light" src={light} />
      <SvgaPlayer className="pop" src={pop} />
      <span className="bg" style={{ backgroundImage: `url(${bg})` }} ></span>
      {isOne ? <>
        <div className="title">您累计点亮了{name}勋章</div>
        <div className="desc">获得{babyCredits}保贝值</div>
        <img className="icon" src={icon} alt="" />
        <div className="name">{name}</div>
      </> : <>
        <div className="title">您已点亮{newGetMedalInfoList.length}个勋章</div>
        <div className="desc">获得{totalBabyCredits}保贝值</div>
        <span className="prize_box" style={{ backgroundImage: `url(${prize_box})` }} ></span>
      </>}
      <span className="close" onClick={this.handleClose} style={{ backgroundImage: `url(${close})` }} />
      <span className="draw_btn" onClick={this.handleDraw} style={{ backgroundImage: `url(${draw_btn})` }} />
    </div>
  }
}
export default LightNewPop;