
import './top-layer.less';
let topLayer;
const layerNames = ['loading', 'toast'];
const layers = [];
export function getLayer(name) {
    if (!topLayer) {
        topLayer = document.createElement("div");
        topLayer.id = 'overlay_layer';
        for (let lname of layerNames) {
            let layer = document.createElement("div");
            layer.id = lname + '_layer';
            topLayer.appendChild(layer);
            layers[lname] = layer;
        }
        document.body.appendChild(topLayer);
    }
    return layers[name];
}

export function parseHtml(htmlText) {
    var el = document.createElement('div');
    el.innerHTML = htmlText;
    return el.children[0];
}
/**
 * 加载图片
 * @ctype PROCESS
 * @description 加载图片
 * @param {string} src - 图片url
 * @param {boolean} [crossOrigin=false] - 是否跨域
 * @returns
 * img HTMLImageElement Image节点
 */
 export function loadImage(src, crossOrigin = false) {
    return new Promise((resolve, reject) => {
        let img = new Image();
        if (crossOrigin) {
            img.crossOrigin = 'anonymous';
        }
        img.onload = function () {
            resolve(img);
        };
        img.onerror = function (e) {
            reject(e);
        };
        img.src = src;
    });
}