
import sensors from 'sa-sdk-javascript';
import { ACTIVITY_SOURCE_CHANNEL, SYS_SOURCE_CHANNEL } from './constants';
import pageleave from './pageleave';
// import { getUrlParam } from './utils';


export const initSensors = (info) => {
  sensors.init({
    server_url: CFG.sensorUrl,
    is_track_single_page: true,
    show_log: true,
    heatmap: {
      clickmap: 'default',
      scroll_notice_map: 'not_collect',
      collect_tags: {
        div: true
      },
    },
  });

  sensors.login(info?.unionid);

  const shareTypeMap = {
    1: "客户邀请",
    2: "业务员邀请"
  }
  const skinId = getUrlParam("skinId");
  // 本次没区分业务员/客户 就null
  const shareType = !!skinId ? shareTypeMap[skinId] : null;

  const publicObjec = Object.assign({
    currentUrl: location.href,
    referrer: document.referrer,
    unionid: info?.unionId,
    openid: info?.openId,
    miniOpenid: info?.miniOpenid,
    officerOrEmp: info?.officerOrEmp,
    subscribeFlg: info?.subscribeFlg,
    programLogin: info?.programLogin,
    userLevel: info?.userLevel,
    source: CFG.channel,
    source_channel: CFG.channel,
    userAccount: '太平洋寿险小程序',
    systemName: '寿险2013版微信公众平台',
    // activityName: CFG.activityName,
    functionalpartition: "增值服务",
    service_name: 'TODO',
    // activityId: '25Searchcharacters',
    // c_date: "2025/06/16-2099/12/31",
    activitySource: ACTIVITY_SOURCE_CHANNEL[CFG.channel] || "",
    sysSourceName: SYS_SOURCE_CHANNEL[CFG.channel] || "",
    friendDistinctId: getUrlParam("uid") || "",
    shareMark: !!getUrlParam("uid") ? "是" : "否",
    shareType: shareType,
    empNp: info?.empNp,
    friendOpenId: info?.friendOpenId,
    empno: info?.newEmpNo,
    friendEmpNp: info?.friendEmpNp,
    friendEmpNo: info?.friendEmpNo,
    wxNickName: info?.nickname,
    sex: info?.sex,
    age: info?.age,
    province: info?.province,
    memberAttribution: info?.memberAttribution,
    memberLevel: info?.customLevel
  }, window['__tbSensorsObj__']);
  sensors.registerPage(publicObjec);
  sensors.quick('autoTrack');
};

export const pageLeave = (pagaName, duration) => {
  sensors.use(pageleave, {
    custom_props: {
      pagaName
    },
    heartbeat_intervaltime: duration,
    max_duration: duration * 24 * 60 * 60,
    isCollectUrl: function (url) {
      return true
    }
  })
}

/**
 * 页面曝光埋点
 * @param {string} eventName
 * @param {{pageName:string,activityName:string,prize:string}} option
 */
export const sensorMdExpouse = (eventName, option) => {
  console.log('神策曝光', eventName, option);
  sensors.track(eventName, option);
};

/**
 * 页面点击埋点
 * @param {string} eventName
 * @param {{pageName:string,activityName:string,buttonName:string,prize:string}} option
 */
export const sensorMdClick = (eventName, option) => {
  console.log('神策点击', eventName, option);
  sensors.track(eventName, option);
};
