import React, { Component } from 'react';
import './prizePage.less';
import { _asyncThrottle, _throttle } from '../../utils/utils';
import skinStore from '../../store/newSkin';
import store from '../../store';
import { PAGE_MAP } from '../../utils/constants';
import { observer } from 'mobx-react';
import { sensorMdClick, sensorMdExpouse } from '../../utils/sensorMd';
import { prizeRecordsApi, tabQueryApi } from '../../api/api';
import Toast from '../../components/toast';
@observer
class PrizePage extends Component {
  constructor(props) {
    super(props);

    this.state = {
      tabList: [],
      curTab: 0,
      prizeList: [],
    }
  }

  async componentDidMount() {
    sensorMdExpouse("xcxPage", { pageName: `奖品页` })

    const res = await tabQueryApi({
      channel: CFG.channel
    });
    if (res.ok) {
      const { tabList } = res.data || {};
      this.setState({ tabList: tabList || [] }, () => {
        if (tabList.length > 0) {
          this.toggleTab(0)
        }
      })
    }
  }

  // 切换tab
  toggleTab = _asyncThrottle(async (index) => {
    this.setState({ curTab: index, prizeList: [] })

    const { tabList } = this.state;
    const res = await prizeRecordsApi({
      channel: CFG.channel,
      id: tabList[index].id
    });
    if (res.ok) {
      this.setState({ prizeList: res.data?.prizeRecords || [] })
    }
  })

  // 奖品详情
  prizeDetail = _asyncThrottle((item) => {
    const { curTab, tabList } = this.state;
    Toast(`前往${tabList[curTab].name}活动查看`)
  })

  // 返回
  backHandle = _asyncThrottle(() => {
    sensorMdClick("xcxClick", { pageName: `奖品页`, buttonName: '返回' })
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { curTab, tabList, prizeList } = this.state;
    const { prize_img_bg, tab_active_bg, title, item_bg } = skinStore.prizePage;
    const { back, sub_page_bg_cover, sub_page_bg } = skinStore.common;
    return (
      <div className="prizePage">
        <div className="bg" style={{ 'backgroundImage': `url(${sub_page_bg})` }}></div>
        {/* 返回 */}
        <div className="back" onClick={this.backHandle} style={{ 'backgroundImage': `url(${back})` }}></div>
        {/* 遮罩 */}
        <div className="bg_cover" style={{ 'backgroundImage': `url(${sub_page_bg_cover})` }}></div>
        {/* 标题 */}
        <div className="title" style={{ 'backgroundImage': `url(${title})` }}></div>
        {/* tab */}
        <div className="tab_list">
          {tabList?.map((item, index) => (
            <div
              className={`tab_item ${curTab === index ? 'active' : ''}`}
              key={`tab_item_${item.id}`}
              onClick={() => this.toggleTab(index)}
              style={{ 'backgroundImage': `url(${curTab === index ? tab_active_bg : ''})` }}
            >
              {item.name}
            </div>
          ))}
        </div>
        {/* 奖品列表 */}
        <div className="prize_list">
          {prizeList?.map((item, index) => (
            <div className="prize_item" style={{ 'backgroundImage': `url(${item_bg})` }} key={index} onClick={() => this.prizeDetail(item)}>
              <div className="prize_img_box" style={{ 'backgroundImage': `url(${prize_img_bg})` }}>
                <img className="prize_img" src={item.prizeImage} alt="" />
              </div>
              <div className="prize_info">
                <div className="prize_name">{item.prizeName}</div>
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  }
}

export default PrizePage;
